/*

    FFT filter
    Copyright (C) 1999-2001 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "dsp/DSPOp.hh"


#ifndef FILTER_HH
    #define FILTER_HH


    /**
        Class implementing FFT-based FIR-filter with design functions.
        Filtering is done in complex-plane.

        \warning Use of this class is deprecated. It is provided only for
        backwards compatibility. Use clFilter2 instead.
    */
    class clFilter : private clDSPOp
    {
            bool bInitialized;
            bool bUseWindow;
            long lWinSize;
            long lFFTSize;
            long lSpectPoints;
            long lLPIdx;
            long lBPLP;
            long lBPHP;
            clDSPAlloc Win;
            clDSPAlloc InvWin;
            clDSPAlloc CoeffWin;
            clDSPAlloc Prev;
            clDSPAlloc Proc;
            clDSPAlloc CCoeffs;
            clDSPAlloc CProc;
            /**
                Initialize complex coefficients.

                \f[\left\vert\begin{array}{l}\Re_{C}(i)=1\\
                \Im_{C}(i)=0\end{array}\right.\f]
            */
            void InitCoeffsS ();
            /// \overload
            void InitCoeffsD ();
            /**
                Create complex impulse response from specified frequency
                response.

                This is done by doing \f$FFT^{-1}(X)\f$, then multiplying
                it with desired window function and doing \f$FFT(x)\f$.
            */
            void ReadyFilterS ();
            /// \overload
            void ReadyFilterD ();
        public:
            clFilter ();
            ~clFilter ();
            /**
                Initialize filter.
                \note Filter FFT size is 2 * window size, so there must be
                window size + 1 coefficients! Window size also must be power
                of two!

                If you use the windowing, then input data is first multiplied
                with window function, then filtered and then inverse window
                function is applied. Used dataset is 50% of internal window
                size and centered on internal window.

                \param WindowSize Size of input window
                \param FiltCoeffs Optional coefficient vector, can be NULL
                \param UseWindowFunc Use window function when filtering
            */
            bool Initialize (long, const float *, bool);
            /// \overload
            bool Initialize (long, const double *, bool);
            /// \overload
            bool InitFloat (long, bool);
            /// \overload
            bool InitDouble (long, bool);
            /**
                Uninitialize filter.
            */
            void Uninitialize ();
            /**
                Set coefficients.

                You can feed the filter with desired frequency response.
                Length of this dataset is specified window size + 1. Filter
                is then created from this coefficient vector.

                \param FiltCoeffs Coefficients for designing filter
            */
            void SetCoeffs (const float *);
            void SetCoeffs (const double *);
            /**
                Get coefficients.

                Get filter's frequency response.

                \param FiltCoeffs Filter coefficients
            */
            void GetCoeffs (float *);
            /// \overload
            void GetCoeffs (double *);
            /**
                Filter data.

                Filtering is done by first multiplying data with optional
                window function, then doing \f$FFT(x)\f$, then doing complex
                multiply with complex impulse response, then doing
                \f$FFT^{-1}(X)\f$ and then multiplying with inverted optional
                window function. Windows overlap 50% and 50% of window length
                is used.

                \param Data Source & destination
            */
            void Process (float *);
            /// \overload
            void Process (double *);
            /**
                Filter data in-place using provided complex coefficients.

                \param Data Source & destination
                \param Coeffs Complex coefficients
            */
            void Process (float *, const stpSCplx);
            /// \overload
            void Process (double *, const stpDCplx);
            /**
                Filter data out-of-place.

                \param Dest Destination
                \param Src Source
            */
            void Process (float *, const float *);
            /// \overload
            void Process (double *, const double *);
            /**
                Filter data out-of-place using provided complex coefficients.

                \param Dest Destination
                \param Src Source
                \param Coeffs Complex coefficients
            */
            void Process (float *, const float *, const stpSCplx);
            /// \overload
            void Process (double *, const double *, const stpDCplx);
            /**
                Low-pass filter data in-place, fast.

                \param Data Source & destination
            */
            void ProcessLP (float *);
            /// \overload
            void ProcessLP (double *);
            /**
                Low-pass filter data out-of-place, fast.

                \param Dest Destination
                \param Src Source
            */
            void ProcessLP (float *, const float *);
            /// \overload
            void ProcessLP (double *, const double *);
            /**
                Band-pass filter data in-place, fast.

                \param Data Source & destination
            */
            void ProcessBP (float *);
            /// \overload
            void ProcessBP (double *);
            /**
                Band-pass filter data out-of-place, fast.

                \param Dest Destination
                \param Src Source
            */
            void ProcessBP (float *, const float *);
            /// \overload
            void ProcessBP (double *, const double *);
            /**
                Design low-pass filter.

                \param Corner Corner frequency
                \param SampleRate Sampling frequency
            */
            void DesignLP (float *, int);
            /// \overload
            void DesignLP (double *, int);
            /**
                Design narrow low-pass filter (for decimation and 
                interpolation).
            */
            void DesignNarrowLP (float *, int);
            /// \overload
            void DesignNarrowLP (double *, int);
            /**
                Design high-pass filter.
            */
            void DesignHP (float *, int);
            /// \overload
            void DesignHP (double *, int);
            /**
                Design band-pass filter.

                \param LowCorner Lower corner frequency
                \param HighCorner Higher corner frequency
                \param SampleRate Sampling frequency
            */
            void DesignBP (float *, float *, int);
            /// \overload
            void DesignBP (double *, double *, int);
            /**
                Design narrow band-pass filter (for zoomed spectrum).
            */
            void DesignNarrowBP (float *, float *, int);
            /// \overload
            void DesignNarrowBP (double *, double *, int);
            /**
                Design band-reject filter.
            */
            void DesignBR (float *, float *, int);
            /// \overload
            void DesignBR (double *, double *, int);
            /**
                Design lowpass filter using frequency divisor.

                \param Divisor Divisor for lowpass filter corner frequency
            */
            void DesignLP (float);
            /// \overload
            void DesignLP (double);
    };

#endif

