#include <cstdio>
#include <unistd.h>

#include "DynThreads.hh"


class clUserThreads
{
        volatile bool bRun;
    public:
        clUserThreads ()
            { bRun = true; }
        void *Thread1 (void *);
        void *Thread2 (void *);
        void *Thread3 (void *);
        void Stop ()
            { bRun = false; }
};


int main (int argc, char *argv[])
{
    int iTime = 0;
    int iTId1, iTId2;
    clUserThreads UserThreads;
    clDynThreads<clUserThreads> DynThreads(UserThreads);
    
    puts("Creating threads...");
    iTId1 = DynThreads.Create(&clUserThreads::Thread1, NULL);
    iTId2 = DynThreads.Create(&clUserThreads::Thread2, NULL);
    DynThreads.Create(&clUserThreads::Thread3, NULL, true);
    
    puts("Threads created, running for 15 seconds...");
    while (iTime < 15)
    {
        sleep(1);
        iTime++;
    }
    UserThreads.Stop();
    puts("Waiting for threads to terminate...");
    //DynThreads.Wait(iTId1);
    DynThreads.Wait(iTId2);

    return 0;
}


void *clUserThreads::Thread1 (void *vpParam)
{
    while (bRun)
    {
        puts("Thread1");
        sleep(1);
    }
    return NULL;
}


void *clUserThreads::Thread2 (void *vpParam)
{
    while (bRun)
    {
        puts("Thread2");
        sleep(1);
    }
    return NULL;
}


void *clUserThreads::Thread3 (void *vpParam)
{
    while (bRun)
    {
        puts("Thread3");
        sleep(1);
    }
    return NULL;
}
