/*

    Decimation filter for rate 3
    Copyright (C) 2002 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Specification:
    F1 = 0.15
    F2 = 0.16667
    Passband Ripple = 0.1dB
    Stopband Ripple = 96dB

*/


#ifdef _MSC_VER
#pragma warning(disable:4305)
#endif


static const long lDec3FilterLen = 369l;

static const float fDec3FilterGain = 1.0f;
static const float fpDec3FilterCoeffs[] = {
    6.55319544416123E-7,
    -1.73305920945372E-7,
    -1.27246493851997E-6,
    -1.42815811997748E-6,
    -3.85334013585032E-9,
    2.03321644353168E-6,
    2.60835392387134E-6,
    5.26071319430461E-7,
    -2.85190590961102E-6,
    -4.26787343247195E-6,
    -1.56752321897176E-6,
    3.59913169716834E-6,
    6.44856955534732E-6,
    3.32634800985166E-6,
    -4.08300926399273E-6,
    -9.14392528958893E-6,
    -6.01225861318321E-6,
    4.043923737956E-6,
    1.22791898622477E-5,
    9.82860675262083E-6,
    -3.15412908163699E-6,
    -1.56912597906821E-5,
    -1.49488955624615E-5,
    1.02365333883325E-6,
    1.91100229011811E-5,
    2.14882049625412E-5,
    2.78619793693982E-6,
    -2.21431879681233E-5,
    -2.94705314322034E-5,
    -8.74075581958327E-6,
    2.42668305023856E-5,
    3.87936150147876E-5,
    1.73007859674878E-5,
    -2.48239621507835E-5,
    -4.91933944005838E-5,
    -2.88822214049239E-5,
    2.30333474447932E-5,
    6.02107521452743E-5,
    4.3807580198104E-5,
    -1.80105248872788E-5,
    -7.11636394548154E-5,
    -6.22505999041385E-5,
    8.80252728911874E-6,
    8.11279561084473E-5,
    8.41764427251633E-5,
    5.56286106762812E-6,
    -8.89306616715749E-5,
    -0.000109280635810934,
    -2.6013311348004E-5,
    9.31584715507503E-5,
    0.000136930651549821,
    5.33546127127693E-5,
    -9.21851183408918E-5,
    -0.000166114640924623,
    -8.81818811031361E-5,
    8.42195215515744E-5,
    0.000195402247512597,
    0.000130782555062888,
    -6.73763096581184E-5,
    -0.000222922593748359,
    -0.0001810355522321,
    3.97689980629204E-5,
    0.000246364397280002,
    0.000238311999253657,
    3.75215621849596E-7,
    -0.000263002710008335,
    -0.000301383813270001,
    -5.45815637465899E-5,
    0.000269755959720343,
    0.000368347026417006,
    0.000123978808792895,
    -0.000263275818874048,
    -0.00043656703403975,
    -0.000209140949424266,
    0.000240070954609786,
    0.000502652853412081,
    0.000309926571964511,
    -0.000196663979506423,
    -0.000562466960806264,
    -0.000425324091630596,
    0.000129778997782993,
    0.000611176311339574,
    0.000553312016729358,
    -3.65551208466971E-5,
    -0.000643348744500593,
    -0.000690743851699293,
    -8.52206797439279E-5,
    0.000653097173198587,
    0.00083326725628924,
    0.000236869882238274,
    -0.000634271809114735,
    -0.000975286544674352,
    -0.000418577991192714,
    0.00058069828362954,
    0.00110997651298766,
    0.000629160696335917,
    -0.000486456998611367,
    -0.00122935393041733,
    -0.000865852633864671,
    0.000346196522963238,
    0.00132441085469258,
    0.0011241308656589,
    -0.000155471492650746,
    -0.00138531130818027,
    -0.00139758459987889,
    -8.89065634196968E-5,
    0.00140164987886247,
    0.00167784134509218,
    0.000388518597075485,
    -0.00136276762265905,
    -0.00195455759673808,
    -0.000743001639129079,
    0.00125811739433597,
    0.00221547930489062,
    0.00114974074704957,
    -0.00107766759355507,
    -0.00244657379464112,
    -0.00160360258585131,
    0.00081233045710387,
    0.0026322305461396,
    0.00209672201003797,
    -0.000454398631483624,
    -0.00275552332526015,
    -0.0026183498845443,
    -2.02801804319948E-6,
    0.00279852058593832,
    0.00315476586906607,
    0.000560644428390384,
    -0.00274262475313233,
    -0.00368925374398521,
    -0.00122259041886266,
    0.00256891368536724,
    0.0042021286610462,
    0.00198616729926872,
    -0.00225844874724545,
    -0.00467079471547224,
    -0.00284663777268132,
    0.00179250238643835,
    0.00506979609710356,
    0.00379612328836698,
    -0.00115264180168389,
    -0.0053708032533017,
    -0.0048236095618486,
    0.000320580244448258,
    0.00554244219568911,
    0.00591506684316126,
    0.000722333841774268,
    -0.00554982104069316,
    -0.0070536868539778,
    -0.00199619208736909,
    0.005353514599532,
    0.00822023333741445,
    0.00352450184159359,
    -0.00490759690147818,
    -0.0093934981040656,
    -0.00533765772934074,
    0.0041559789776743,
    0.0105508495605035,
    0.00747903645744014,
    -0.00302562000565543,
    -0.011668856218755,
    -0.0100160026174477,
    0.00141364619694381,
    0.0127239638406881,
    0.0130608463397966,
    0.000838301625876309,
    -0.0136932018772601,
    -0.0168137558179854,
    -0.00399915314312267,
    0.0145548928886926,
    0.0216606790071026,
    0.00858030820468855,
    -0.0152893377993077,
    -0.0284306286912144,
    -0.0157054090168893,
    0.0158794502159354,
    0.0392306898593638,
    0.0284312021621593,
    -0.0163113146272427,
    -0.0612847237452438,
    -0.0590119790120875,
    0.016574646047368,
    0.145313976958113,
    0.266919832542751,
    0.316666182523057,
    0.266919832542751,
    0.145313976958113,
    0.016574646047368,
    -0.0590119790120875,
    -0.0612847237452438,
    -0.0163113146272427,
    0.0284312021621593,
    0.0392306898593638,
    0.0158794502159354,
    -0.0157054090168893,
    -0.0284306286912144,
    -0.0152893377993077,
    0.00858030820468855,
    0.0216606790071026,
    0.0145548928886926,
    -0.00399915314312267,
    -0.0168137558179854,
    -0.0136932018772601,
    0.000838301625876309,
    0.0130608463397966,
    0.0127239638406881,
    0.00141364619694381,
    -0.0100160026174477,
    -0.011668856218755,
    -0.00302562000565543,
    0.00747903645744014,
    0.0105508495605035,
    0.0041559789776743,
    -0.00533765772934074,
    -0.0093934981040656,
    -0.00490759690147818,
    0.00352450184159359,
    0.00822023333741445,
    0.005353514599532,
    -0.00199619208736909,
    -0.0070536868539778,
    -0.00554982104069316,
    0.000722333841774268,
    0.00591506684316126,
    0.00554244219568911,
    0.000320580244448258,
    -0.0048236095618486,
    -0.0053708032533017,
    -0.00115264180168389,
    0.00379612328836698,
    0.00506979609710356,
    0.00179250238643835,
    -0.00284663777268132,
    -0.00467079471547224,
    -0.00225844874724545,
    0.00198616729926872,
    0.0042021286610462,
    0.00256891368536724,
    -0.00122259041886266,
    -0.00368925374398521,
    -0.00274262475313233,
    0.000560644428390384,
    0.00315476586906607,
    0.00279852058593832,
    -2.02801804319948E-6,
    -0.0026183498845443,
    -0.00275552332526015,
    -0.000454398631483624,
    0.00209672201003797,
    0.0026322305461396,
    0.00081233045710387,
    -0.00160360258585131,
    -0.00244657379464112,
    -0.00107766759355507,
    0.00114974074704957,
    0.00221547930489062,
    0.00125811739433597,
    -0.000743001639129079,
    -0.00195455759673808,
    -0.00136276762265905,
    0.000388518597075485,
    0.00167784134509218,
    0.00140164987886247,
    -8.89065634196968E-5,
    -0.00139758459987889,
    -0.00138531130818027,
    -0.000155471492650746,
    0.0011241308656589,
    0.00132441085469258,
    0.000346196522963238,
    -0.000865852633864671,
    -0.00122935393041733,
    -0.000486456998611367,
    0.000629160696335917,
    0.00110997651298766,
    0.00058069828362954,
    -0.000418577991192714,
    -0.000975286544674352,
    -0.000634271809114735,
    0.000236869882238274,
    0.00083326725628924,
    0.000653097173198587,
    -8.52206797439279E-5,
    -0.000690743851699293,
    -0.000643348744500593,
    -3.65551208466971E-5,
    0.000553312016729358,
    0.000611176311339574,
    0.000129778997782993,
    -0.000425324091630596,
    -0.000562466960806264,
    -0.000196663979506423,
    0.000309926571964511,
    0.000502652853412081,
    0.000240070954609786,
    -0.000209140949424266,
    -0.00043656703403975,
    -0.000263275818874048,
    0.000123978808792895,
    0.000368347026417006,
    0.000269755959720343,
    -5.45815637465899E-5,
    -0.000301383813270001,
    -0.000263002710008335,
    3.75215621849596E-7,
    0.000238311999253657,
    0.000246364397280002,
    3.97689980629204E-5,
    -0.0001810355522321,
    -0.000222922593748359,
    -6.73763096581184E-5,
    0.000130782555062888,
    0.000195402247512597,
    8.42195215515744E-5,
    -8.81818811031361E-5,
    -0.000166114640924623,
    -9.21851183408918E-5,
    5.33546127127693E-5,
    0.000136930651549821,
    9.31584715507503E-5,
    -2.6013311348004E-5,
    -0.000109280635810934,
    -8.89306616715749E-5,
    5.56286106762812E-6,
    8.41764427251633E-5,
    8.11279561084473E-5,
    8.80252728911874E-6,
    -6.22505999041385E-5,
    -7.11636394548154E-5,
    -1.80105248872788E-5,
    4.3807580198104E-5,
    6.02107521452743E-5,
    2.30333474447932E-5,
    -2.88822214049239E-5,
    -4.91933944005838E-5,
    -2.48239621507835E-5,
    1.73007859674878E-5,
    3.87936150147876E-5,
    2.42668305023856E-5,
    -8.74075581958327E-6,
    -2.94705314322034E-5,
    -2.21431879681233E-5,
    2.78619793693982E-6,
    2.14882049625412E-5,
    1.91100229011811E-5,
    1.02365333883325E-6,
    -1.49488955624615E-5,
    -1.56912597906821E-5,
    -3.15412908163699E-6,
    9.82860675262083E-6,
    1.22791898622477E-5,
    4.043923737956E-6,
    -6.01225861318321E-6,
    -9.14392528958893E-6,
    -4.08300926399273E-6,
    3.32634800985166E-6,
    6.44856955534732E-6,
    3.59913169716834E-6,
    -1.56752321897176E-6,
    -4.26787343247195E-6,
    -2.85190590961102E-6,
    5.26071319430461E-7,
    2.60835392387134E-6,
    2.03321644353168E-6,
    -3.85334013585032E-9,
    -1.42815811997748E-6,
    -1.27246493851997E-6,
    -1.73305920945372E-7,
    6.55319544416123E-7
};


static const double dDec3FilterGain = 1.0;
static const double dpDec3FilterCoeffs[] = {
    6.55319544416123E-7,
    -1.73305920945372E-7,
    -1.27246493851997E-6,
    -1.42815811997748E-6,
    -3.85334013585032E-9,
    2.03321644353168E-6,
    2.60835392387134E-6,
    5.26071319430461E-7,
    -2.85190590961102E-6,
    -4.26787343247195E-6,
    -1.56752321897176E-6,
    3.59913169716834E-6,
    6.44856955534732E-6,
    3.32634800985166E-6,
    -4.08300926399273E-6,
    -9.14392528958893E-6,
    -6.01225861318321E-6,
    4.043923737956E-6,
    1.22791898622477E-5,
    9.82860675262083E-6,
    -3.15412908163699E-6,
    -1.56912597906821E-5,
    -1.49488955624615E-5,
    1.02365333883325E-6,
    1.91100229011811E-5,
    2.14882049625412E-5,
    2.78619793693982E-6,
    -2.21431879681233E-5,
    -2.94705314322034E-5,
    -8.74075581958327E-6,
    2.42668305023856E-5,
    3.87936150147876E-5,
    1.73007859674878E-5,
    -2.48239621507835E-5,
    -4.91933944005838E-5,
    -2.88822214049239E-5,
    2.30333474447932E-5,
    6.02107521452743E-5,
    4.3807580198104E-5,
    -1.80105248872788E-5,
    -7.11636394548154E-5,
    -6.22505999041385E-5,
    8.80252728911874E-6,
    8.11279561084473E-5,
    8.41764427251633E-5,
    5.56286106762812E-6,
    -8.89306616715749E-5,
    -0.000109280635810934,
    -2.6013311348004E-5,
    9.31584715507503E-5,
    0.000136930651549821,
    5.33546127127693E-5,
    -9.21851183408918E-5,
    -0.000166114640924623,
    -8.81818811031361E-5,
    8.42195215515744E-5,
    0.000195402247512597,
    0.000130782555062888,
    -6.73763096581184E-5,
    -0.000222922593748359,
    -0.0001810355522321,
    3.97689980629204E-5,
    0.000246364397280002,
    0.000238311999253657,
    3.75215621849596E-7,
    -0.000263002710008335,
    -0.000301383813270001,
    -5.45815637465899E-5,
    0.000269755959720343,
    0.000368347026417006,
    0.000123978808792895,
    -0.000263275818874048,
    -0.00043656703403975,
    -0.000209140949424266,
    0.000240070954609786,
    0.000502652853412081,
    0.000309926571964511,
    -0.000196663979506423,
    -0.000562466960806264,
    -0.000425324091630596,
    0.000129778997782993,
    0.000611176311339574,
    0.000553312016729358,
    -3.65551208466971E-5,
    -0.000643348744500593,
    -0.000690743851699293,
    -8.52206797439279E-5,
    0.000653097173198587,
    0.00083326725628924,
    0.000236869882238274,
    -0.000634271809114735,
    -0.000975286544674352,
    -0.000418577991192714,
    0.00058069828362954,
    0.00110997651298766,
    0.000629160696335917,
    -0.000486456998611367,
    -0.00122935393041733,
    -0.000865852633864671,
    0.000346196522963238,
    0.00132441085469258,
    0.0011241308656589,
    -0.000155471492650746,
    -0.00138531130818027,
    -0.00139758459987889,
    -8.89065634196968E-5,
    0.00140164987886247,
    0.00167784134509218,
    0.000388518597075485,
    -0.00136276762265905,
    -0.00195455759673808,
    -0.000743001639129079,
    0.00125811739433597,
    0.00221547930489062,
    0.00114974074704957,
    -0.00107766759355507,
    -0.00244657379464112,
    -0.00160360258585131,
    0.00081233045710387,
    0.0026322305461396,
    0.00209672201003797,
    -0.000454398631483624,
    -0.00275552332526015,
    -0.0026183498845443,
    -2.02801804319948E-6,
    0.00279852058593832,
    0.00315476586906607,
    0.000560644428390384,
    -0.00274262475313233,
    -0.00368925374398521,
    -0.00122259041886266,
    0.00256891368536724,
    0.0042021286610462,
    0.00198616729926872,
    -0.00225844874724545,
    -0.00467079471547224,
    -0.00284663777268132,
    0.00179250238643835,
    0.00506979609710356,
    0.00379612328836698,
    -0.00115264180168389,
    -0.0053708032533017,
    -0.0048236095618486,
    0.000320580244448258,
    0.00554244219568911,
    0.00591506684316126,
    0.000722333841774268,
    -0.00554982104069316,
    -0.0070536868539778,
    -0.00199619208736909,
    0.005353514599532,
    0.00822023333741445,
    0.00352450184159359,
    -0.00490759690147818,
    -0.0093934981040656,
    -0.00533765772934074,
    0.0041559789776743,
    0.0105508495605035,
    0.00747903645744014,
    -0.00302562000565543,
    -0.011668856218755,
    -0.0100160026174477,
    0.00141364619694381,
    0.0127239638406881,
    0.0130608463397966,
    0.000838301625876309,
    -0.0136932018772601,
    -0.0168137558179854,
    -0.00399915314312267,
    0.0145548928886926,
    0.0216606790071026,
    0.00858030820468855,
    -0.0152893377993077,
    -0.0284306286912144,
    -0.0157054090168893,
    0.0158794502159354,
    0.0392306898593638,
    0.0284312021621593,
    -0.0163113146272427,
    -0.0612847237452438,
    -0.0590119790120875,
    0.016574646047368,
    0.145313976958113,
    0.266919832542751,
    0.316666182523057,
    0.266919832542751,
    0.145313976958113,
    0.016574646047368,
    -0.0590119790120875,
    -0.0612847237452438,
    -0.0163113146272427,
    0.0284312021621593,
    0.0392306898593638,
    0.0158794502159354,
    -0.0157054090168893,
    -0.0284306286912144,
    -0.0152893377993077,
    0.00858030820468855,
    0.0216606790071026,
    0.0145548928886926,
    -0.00399915314312267,
    -0.0168137558179854,
    -0.0136932018772601,
    0.000838301625876309,
    0.0130608463397966,
    0.0127239638406881,
    0.00141364619694381,
    -0.0100160026174477,
    -0.011668856218755,
    -0.00302562000565543,
    0.00747903645744014,
    0.0105508495605035,
    0.0041559789776743,
    -0.00533765772934074,
    -0.0093934981040656,
    -0.00490759690147818,
    0.00352450184159359,
    0.00822023333741445,
    0.005353514599532,
    -0.00199619208736909,
    -0.0070536868539778,
    -0.00554982104069316,
    0.000722333841774268,
    0.00591506684316126,
    0.00554244219568911,
    0.000320580244448258,
    -0.0048236095618486,
    -0.0053708032533017,
    -0.00115264180168389,
    0.00379612328836698,
    0.00506979609710356,
    0.00179250238643835,
    -0.00284663777268132,
    -0.00467079471547224,
    -0.00225844874724545,
    0.00198616729926872,
    0.0042021286610462,
    0.00256891368536724,
    -0.00122259041886266,
    -0.00368925374398521,
    -0.00274262475313233,
    0.000560644428390384,
    0.00315476586906607,
    0.00279852058593832,
    -2.02801804319948E-6,
    -0.0026183498845443,
    -0.00275552332526015,
    -0.000454398631483624,
    0.00209672201003797,
    0.0026322305461396,
    0.00081233045710387,
    -0.00160360258585131,
    -0.00244657379464112,
    -0.00107766759355507,
    0.00114974074704957,
    0.00221547930489062,
    0.00125811739433597,
    -0.000743001639129079,
    -0.00195455759673808,
    -0.00136276762265905,
    0.000388518597075485,
    0.00167784134509218,
    0.00140164987886247,
    -8.89065634196968E-5,
    -0.00139758459987889,
    -0.00138531130818027,
    -0.000155471492650746,
    0.0011241308656589,
    0.00132441085469258,
    0.000346196522963238,
    -0.000865852633864671,
    -0.00122935393041733,
    -0.000486456998611367,
    0.000629160696335917,
    0.00110997651298766,
    0.00058069828362954,
    -0.000418577991192714,
    -0.000975286544674352,
    -0.000634271809114735,
    0.000236869882238274,
    0.00083326725628924,
    0.000653097173198587,
    -8.52206797439279E-5,
    -0.000690743851699293,
    -0.000643348744500593,
    -3.65551208466971E-5,
    0.000553312016729358,
    0.000611176311339574,
    0.000129778997782993,
    -0.000425324091630596,
    -0.000562466960806264,
    -0.000196663979506423,
    0.000309926571964511,
    0.000502652853412081,
    0.000240070954609786,
    -0.000209140949424266,
    -0.00043656703403975,
    -0.000263275818874048,
    0.000123978808792895,
    0.000368347026417006,
    0.000269755959720343,
    -5.45815637465899E-5,
    -0.000301383813270001,
    -0.000263002710008335,
    3.75215621849596E-7,
    0.000238311999253657,
    0.000246364397280002,
    3.97689980629204E-5,
    -0.0001810355522321,
    -0.000222922593748359,
    -6.73763096581184E-5,
    0.000130782555062888,
    0.000195402247512597,
    8.42195215515744E-5,
    -8.81818811031361E-5,
    -0.000166114640924623,
    -9.21851183408918E-5,
    5.33546127127693E-5,
    0.000136930651549821,
    9.31584715507503E-5,
    -2.6013311348004E-5,
    -0.000109280635810934,
    -8.89306616715749E-5,
    5.56286106762812E-6,
    8.41764427251633E-5,
    8.11279561084473E-5,
    8.80252728911874E-6,
    -6.22505999041385E-5,
    -7.11636394548154E-5,
    -1.80105248872788E-5,
    4.3807580198104E-5,
    6.02107521452743E-5,
    2.30333474447932E-5,
    -2.88822214049239E-5,
    -4.91933944005838E-5,
    -2.48239621507835E-5,
    1.73007859674878E-5,
    3.87936150147876E-5,
    2.42668305023856E-5,
    -8.74075581958327E-6,
    -2.94705314322034E-5,
    -2.21431879681233E-5,
    2.78619793693982E-6,
    2.14882049625412E-5,
    1.91100229011811E-5,
    1.02365333883325E-6,
    -1.49488955624615E-5,
    -1.56912597906821E-5,
    -3.15412908163699E-6,
    9.82860675262083E-6,
    1.22791898622477E-5,
    4.043923737956E-6,
    -6.01225861318321E-6,
    -9.14392528958893E-6,
    -4.08300926399273E-6,
    3.32634800985166E-6,
    6.44856955534732E-6,
    3.59913169716834E-6,
    -1.56752321897176E-6,
    -4.26787343247195E-6,
    -2.85190590961102E-6,
    5.26071319430461E-7,
    2.60835392387134E-6,
    2.03321644353168E-6,
    -3.85334013585032E-9,
    -1.42815811997748E-6,
    -1.27246493851997E-6,
    -1.73305920945372E-7,
    6.55319544416123E-7
};
