/*

    Decimation class, header
    Copyright (C) 2000-2001 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <Alloc.hh>

#include "dsp/DSPOp.hh"


#ifndef DECIMATOR_HH
    #define DECIMATOR_HH


    #define DEC_MAX_SUB_ROUNDS          8  ///< Maximum number of subsequent rounds


    /**
        Decimation filter class implementation.

        Data is is filtered using FIR filter and decimated in recursive manner
        in rounds of factor 2, 4 or 8.

        \note See clFIRDecimator and clRecDecimator classes for easier to use
        implementation.
    */
    class clDecimator
    {
            long lBufferSize;  ///< Size of input buffer
            long lSubRounds;  ///< Number of recursive rounds
            long lpSubFactors[DEC_MAX_SUB_ROUNDS];  ///< Decimation factors for rounds
            float *fpDecBuf;
            double *dpDecBuf;
            float fpGains[DEC_MAX_SUB_ROUNDS];
            double dpGains[DEC_MAX_SUB_ROUNDS];
            clAlloc DecBuf;
            clDSPOp DSP;
            clDSPOp FIRBank[DEC_MAX_SUB_ROUNDS];
        public:
            clDecimator ();
            ~clDecimator ();
            /**
                Initialize decimator, decimation factor and buffer size must
                be powers of two. You can re-initialize decimator without
                uninitializing first.

                The NULL pointer is used select correct overloaded function
                matching input datatype.

                \param DecFact Decimation factor
                \param BufSize Size of input buffer
                \param NullPtr NULL pointer
            */
            bool Initialize (long, long, const float *);
            /// \overload
            bool Initialize (long, long, const double *);
            /**
                Uninitialize decimator
            */
            void Uninitialize ();
            /**
                Filter and decimate data in-place

                \param Vect Source & destination
            */
            void Process (float *);
            /// \overload
            void Process (double *);
            /**
                Filter and decimate data out-of-place

                \param Dest Destination
                \param Src Source
            */
            void Process (float *, const float *);
            /// \overload
            void Process (double *, const double *);
    };

#endif

