/*

    x86 specific optimized assembler dsp routines
    Copyright (C) 2001-2002 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifdef DSP_X86

#ifndef X86_H
    #define X86_H

    #define X86_ASM     asm volatile

    #pragma pack(1)

    typedef struct _stm64
    {
        float f[2];
    } stm64, *stpm64;

    typedef struct _stm128
    {
        union
        {
            float f[4];
            double d[2];
        };
    } stm128, *stpm128;

    #pragma pack()


    #ifdef __cplusplus
    extern "C"
    {
    #endif

    const char *dsp_x86_cpuid (void);
    unsigned int dsp_x86_features (void);
    unsigned int dsp_x86_amd_features (void);
    int dsp_x86_have_e3dnow (void);
    int dsp_x86_have_sse2 (void);
    void dsp_x86_3dnow_copyf (float *, const float *, int);
    void dsp_x86_3dnow_copyd (double *, const double *, int);
    void dsp_x86_3dnow_addf (float *, float, int);
    void dsp_x86_3dnow_mulf (float *, float, int);
    void dsp_x86_3dnow_mulf_nip (float *, const float *, float, int);
    void dsp_x86_3dnow_add2f (float *, const float *, int);
    void dsp_x86_3dnow_mul2f (float *, const float *, int);
    void dsp_x86_3dnow_add3f (float *, const float *, const float *, int);
    void dsp_x86_3dnow_mul3f (float *, const float *, const float *, int);
    void dsp_x86_3dnow_cmulf (float *, const float *, int);
    void dsp_x86_3dnow_cmul2f (float *, const float *, int);
    void dsp_x86_3dnow_cmul3f (float *, const float *, const float *, int);
    void dsp_x86_3dnow_maf (float *, float, float, int);
    void dsp_x86_3dnow_ma2f (float *, const float *, float, float, int);
    void dsp_x86_3dnow_amf (float *, float, float, int);
    float dsp_x86_3dnow_macf (const float *, const float *, int);
    void dsp_x86_3dnow_minmaxf (float *, float *, const float *, int);
    float dsp_x86_3dnow_crosscorrf (const float *, const float *, int);
    void dsp_x86_3dnow_i16tof (float *, const short *, int, int);
    void dsp_x86_3dnow_i32tof (float *, const int *, int, int);
    void dsp_x86_3dnow_ftoi16 (short *, const float *, int);
    // not in-place capable
    void dsp_x86_3dnow_firf (float *, const float *, int, const float *, int);
    void dsp_x86_3dnow_iirf (float *, int, const float *, float *, float *);
    void dsp_x86_3dnow_iirf_nip (float *, const float *, int, const float *, 
        float *, float *);

    #ifdef __cplusplus
    }
    #endif

#endif

#endif
