#include <stdio.h>
#include <string.h>
#include "dsp/X86.h"

int main (int argc, char *argv[])
{
    const char *cpCPUid;
    unsigned int uiFeatures;
    unsigned int uiAMDFeatures;

    cpCPUid = dsp_x86_cpuid();
    printf("%s\n", cpCPUid);
    uiFeatures = dsp_x86_features();
    printf("%x\n", uiFeatures);
    if (uiFeatures & (1 << 23))
        printf("MMX\n");
    if (uiFeatures & (1 << 25))
        printf("SSE\n");
    if (uiFeatures & (1 << 26))
        printf("SSE2\n");
    if (strcmp(cpCPUid, "AuthenticAMD") == 0)
    {
        uiAMDFeatures = dsp_x86_amd_features();
        printf("%x\n", uiAMDFeatures);
        if (uiAMDFeatures & (1 << 22))
            printf("MMX extensions\n");
        if (uiAMDFeatures & (1 << 31))
            printf("3DNow!\n");
        if (uiAMDFeatures & (1 << 30))
            printf("3DNow! extensions\n");
    }
    if (dsp_x86_have_e3dnow())
        printf("Has Enhanced3DNow!\n");
    if (dsp_x86_have_sse2())
        printf("Has SSE2\n");

    return 0;
}
