#  Copyright 2000, 2001, 2002 Laurent Wacrenier
#
#  This file is part of libhome
#
#  libhome is free software; you can redistribute it and/or modify it
#  under the terms of the GNU Lesser General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  libhome is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with libhome; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA
#
# $Id: Home.pm,v 1.4 2002/11/27 16:22:26 lwa Exp $

package Home;

require 5.005;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);

require Exporter;
require DynaLoader;


@ISA = qw(Exporter DynaLoader);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Home ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
%EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

@EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

@EXPORT = qw(
	
);

$VERSION='1.00';
bootstrap Home $VERSION;

# Preloaded methods go here.

1;
__END__
# Below is stub documentation for your module. You better edit it!

=head1 NAME

Home - Perl extension for libhome emulation

=head1 SYNOPSIS

  use Home;

  ($name,$passwd,$uid,$gid,$quota,$comment,$gcos,$dir,$shell,$expire) = 
	getpwnam("..")
  ($name,$passwd,$uid,$gid,$quota,$comment,$gcos,$dir,$shell,$expire) = 
        getpwuid("..")
  ($name,$passwd,$uid,$gid,$quota,$comment,$gcos,$dir,$shell,$expire) = 
         getpwent()
  setpassent($stayopen)
  setpwent()
  setpwent()
  endpwent()

  setpwtag($tag)

  rewrite($user)
  hash($user [, $path])

=head1 DESCRIPTION

  provide libhome equivalemnt to perl or C getpw* functions

  "setpwtag" set the tag used in home.conf

  "rewrite" canonify an user name

  "hash" returns the home directory of a canonified user
  according optional path specifications
  

=head2 EXPORT

None by default.

=head1 AUTHOR

  lwa@teaser.fr

=head1 SEE ALSO

perl(1), getpwnam(3), libhome(3), home.conf(5).

=cut
