/*

  Copyright 2000, 2001, 2002 Laurent Wacrenier

  This file is part of libhome

  libhome is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  libhome is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with libhome; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA

*/

#include "config.h"

static char const rcsid[] UNUSED = 
"$Id: home_finger.c,v 1.8 2005/06/23 13:02:59 lwa Exp $";

/* #define HOME_CRYPT */
#include <pwd.h>

#if HAVE_CRYPT_H
#include <crypt.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>


extern int optind;

int main(int argc, char **argv) {
  struct passwd *p;
  int i;
  int ch;
  int loop = -1;
  char *trypass=NULL;
  int verbose = 0;
  int checkuid = 0;

  while ((ch = getopt(argc, argv, "h?t:kn:p:vu")) != -1) {
    switch (ch) {
    case 'v':
      verbose = 1;
    case 'p':
      trypass=optarg;
      break;
    case 't':
      setpwtag(optarg);
      break;
    case 'k':
      setpassent(1);
      break;
    case 'n':
      loop = strtol(optarg, NULL, 10);
      break;
    case 'u':
      checkuid = 1;
      break;
    case 'h':
    case '?':
      fprintf(stderr, "%s [ -t tag ] [ -n number ] [-k] [-u] [ -p passwd ] [ user ]\n"
	      " -t tag     set tag in use for getpw*\n"
	      " -n #       number of loops\n"
	      " -k         keep persistent connection to database\n"
	      " -p passwd  try to authentify with this password\n",
	      " -u         check for UID\n"
	      " -v         verbose output for loops\n",
	      argv[0]);
      return 1;
	      
    }
  }

  argc -= optind;
  argv += optind;

  if(argc==0) {
    while((p=getpwent())!=NULL) {
      printf("%s:%s:%d:%d:%s:%s:%s\n",
	     p->pw_name, p->pw_passwd, (int)p->pw_uid, (int)p->pw_gid,
	     p->pw_gecos, p->pw_dir, p->pw_shell);
    }
    endpwent();
    return 0;
  }


  do {
    
    if ((p=(checkuid ?
	    getpwuid(strtol(argv[0], NULL, 10)) : getpwnam(argv[0])))!=NULL) {
      if (loop<0) {
	printf("login: %s\npasswd: %s\nuid: %d\ngid: %d\n"
	       "gecos: %s\nhome: %s\nshell: %s\nexpire: %d\n"
	       "quota: %d\nclass: %s\n", 
	       p->pw_name, p->pw_passwd, (int)p->pw_uid,
	       (int)p->pw_gid, p->pw_gecos, p->pw_dir, p->pw_shell,
	       (int)p->pw_expire, (int)p->pw_quota, p->pw_class);

	if (trypass) {
	  /*
	  printf("c=%s s=%d\n", crypt(trypass, p->pw_passwd),
		 strcmp(crypt(trypass, p->pw_passwd), p->pw_passwd));
	  */
	  if (strcmp(crypt(trypass, p->pw_passwd), p->pw_passwd)==0) {
	    printf("Authentificator ok\n");
	  } else {
	    printf("Wrong authentificator\n");
	  }
	}
      } else {
	if (verbose) {
	  fputc('+', stdout);
	  fflush(stdout);
	}
      }
    } else {
      if (loop < 0) {
	if (errno == ENOMEM) {
	  printf("transcient error\n");
	} else {
	  printf("not found\n");
	}
      } else {
	if (verbose) {
	  fputc(errno == ENOMEM ? '?' : '-', stdout);
	  fflush(stdout);
	}
      }
    }
  } while(--loop>0);
  
  if (verbose) {
    fputc('\n', stdout);
  }
  endpwent();
  return 0;
}
