/*

  Copyright 2000, 2001, 2002 Laurent Wacrenier

  This file is part of libhome

  libhome is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  libhome is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with libhome; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA

*/

#include "config.h"

static char const rcsid[] UNUSED = 
"$Id: home_su.c,v 1.3 2005/02/10 14:29:58 lwa Exp $";

#include <unistd.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <pwd.h>

extern int optind;

void usage(char *me) {
  fprintf(stderr, "usage: %s [ -t tag ] user [ command ... ]\n", me);
}

int main(int argc, char **argv) {
  int ch;
  struct passwd *p;
  char *me ;
  char *shell[] = { "/bin/sh", NULL };

  if ( (me = strrchr(argv[0], '/')) == NULL ) {
    me = argv[0];
  } else {
    *me ++ = 0;
  }


  while((ch = getopt(argc, argv, "h?t:")) != -1) {
    switch(ch) {
    case 't':
      setpwtag(optarg);
      break;
    case '?': case 'h':
      usage(me);
      return 1;
    }
  }
  argc -= optind;
  argv += optind;

  if (argc == 0) {
    usage(me);
    return 1;
  }

  p = getpwnam(argv[0]);
  if (p == NULL) {
    fprintf(stderr, "%s: unknown user %s\n", me, argv[0]);
    return 1;
  }
  
  setgid(p->pw_gid);
  setuid(p->pw_uid);
  if (chdir(p->pw_dir) == -1) {
    fprintf(stderr, "chdir %s: %s\n", p->pw_dir, strerror(errno));
    return 1;
  }

  argv++;

  if (argv[0] == NULL) {
    char *myshell = getenv("SHELL");
    if (myshell)
      shell[0] = myshell;
    argv = shell;
  }

  execvp(argv[0], argv);
  fprintf(stderr, "exec %s: %s\n", argv[0], strerror(errno));
}
