/*

  Copyright 2000, 2001, 2002 Laurent Wacrenier

  This file is part of libhome

  libhome is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  libhome is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with libhome; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA

*/

/* $Id: hpwd.h,v 1.14 2005/09/14 08:57:00 lwa Exp $ */

#ifndef _HPWD_H_
#define _HPWD_H_

#include <sys/types.h>

/* DONT_SUBSTITUTE_SYSTEM is a legacy name, it remain for historical
   reasons */
#ifdef DONT_SUBSTITUTE_SYSTEM
#undef HOME_DONT_SUBSTITUTE_SYSTEM
#define HOME_DONT_SUBSTITUTE_SYSTEM
#endif

#ifndef HOME_DONT_SUBSTITUTE_SYSTEM
#define endpwent home_endpwent
#define getpwnam home_getpwnam
#define setpassent home_setpassent
#define setpwent home_setpwent
#define getpwuid home_getpwuid
#define getpwent home_getpwent
#endif


#ifdef HOME_CRYPT
#define crypt(x,y) home_crypt((x),(y))
#endif

#ifndef USE_SYS_PW_FIELDS
#define HAS_PW_CHANGE
#define HAS_PW_CLASS
#define HAS_PW_EXPIRE
#define HAS_PW_QUOTA
#else
# ifdef __FreeBSD__
# define HAS_PW_CHANGE
# define HAS_PW_CLASS
# define HAS_PW_EXPIRE
# define HAS_PW_FIELDS
# endif
#endif

struct passwd {
  char *pw_name;
  char *pw_passwd;
  uid_t pw_uid;
  gid_t pw_gid;
#ifdef HAS_PW_CHANGE
  time_t  pw_change; 
#endif
#ifdef HAS_PW_QUOTA
  int pw_quota;
#endif
#ifdef HAS_PW_CLASS
  char    *pw_class;
#endif
  char *pw_gecos;
  char *pw_dir;
  char *pw_shell;
#ifdef HAS_PW_EXPIRE
  time_t  pw_expire;
#endif
#ifdef HAS_PW_FIELDS
  int     pw_fields;
#endif
};

struct passwd *home_getpwent(void);
struct passwd *home_getpwnam(char *login);
struct passwd *home_getpwuid(uid_t uid);
int home_setpassent(int stayopen);
void home_setpwent(void);
void home_endpwent(void);
void home_checkpassw(char *claimed,char *crypted);

char *home_crypt(char *key, char *salt);
int home_crypted(char *passwd);

char *setpwtag(char *tag);

#endif
