/*
  Copyright 2000, 2001, 2002 Laurent Wacrenier

  This file is part of libhome

  libhome is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  libhome is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with libhome; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA
*/

/* $Id: Home.xs,v 1.9 2002/11/27 16:22:26 lwa Exp $ */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <sys/types.h>
#include <hparam.h>

MODULE = Home		PACKAGE = Home		

void
setpwtag(tag)
        char *tag
   PROTOTYPE: $
   CODE:
	setpwtag(tag);

void
getpwnam(user)
	char *user
   PROTOTYPE: $
   INIT:
	struct passwd *p;
   PPCODE:
	p=getpwnam(user);
	if (p) {
		XPUSHs(sv_2mortal(newSVpv(p->pw_name?p->pw_name:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_passwd?p->pw_passwd:"*",0)));
		XPUSHs(sv_2mortal(newSVnv(p->pw_uid)));
		XPUSHs(sv_2mortal(newSVnv(p->pw_gid)));
#ifdef HAS_PW_QUOTA
		XPUSHs(sv_2mortal(newSVnv(p->pw_quota)));
#else
		XPUSHs(sv_2mortal(newSVnv(0)));
#endif
#ifdef HAS_PW_CLASS
		XPUSHs(sv_2mortal(newSVpv(p->pw_class?p->pw_class:"",0)));
#else
		XPUSHs(sv_2mortal(newSVpv("",0)));
#endif
		XPUSHs(sv_2mortal(newSVpv(p->pw_gecos?p->pw_gecos:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_dir?p->pw_dir:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_shell?p->pw_shell:"",0)));
#ifdef HAS_PW_EXPIRE
		XPUSHs(sv_2mortal(newSVnv(p->pw_expire)));
#else
		XPUSHs(sv_2mortal(newSVnv(0)));
#endif
	}

void
getpwent()
   PREINIT:
	struct passwd *p;
   PROTOTYPE:
   PPCODE:
        p=getpwent();
	if (p) {
		XPUSHs(sv_2mortal(newSVpv(p->pw_name?p->pw_name:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_passwd?p->pw_passwd:"*",0)));
		XPUSHs(sv_2mortal(newSVnv(p->pw_uid)));
#ifdef HAS_PW_QUOTA
		XPUSHs(sv_2mortal(newSVnv(p->pw_quota)));
#else
		XPUSHs(sv_2mortal(newSVnv(0)));
#endif
		XPUSHs(sv_2mortal(newSVnv(p->pw_gid)));
#ifdef HAS_PW_CLASS
		XPUSHs(sv_2mortal(newSVpv(p->pw_class?p->pw_class:"",0)));
#else
		XPUSHs(sv_2mortal(newSVpv("",0)));
#endif
		XPUSHs(sv_2mortal(newSVpv(p->pw_gecos?p->pw_gecos:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_dir?p->pw_dir:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_shell?p->pw_shell:"",0)));
#ifdef HAS_PW_EXPIRE
		XPUSHs(sv_2mortal(newSVnv(p->pw_expire)));
#else
		XPUSHs(sv_2mortal(newSVnv(0)));
#endif
        }

void
getpwuid(uid)
	long uid;
    PROTOTYPE: $
    INIT:
	struct passwd *p;
    PPCODE:
        p=getpwuid(uid);
	if (p) {
		XPUSHs(sv_2mortal(newSVpv(p->pw_name?p->pw_name:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_passwd?p->pw_passwd:"*",0)));
		XPUSHs(sv_2mortal(newSVnv(p->pw_uid)));
		XPUSHs(sv_2mortal(newSVnv(p->pw_gid)));
#ifdef HAS_PW_QUOTA
		XPUSHs(sv_2mortal(newSVnv(p->pw_quota)));
#else
		XPUSHs(sv_2mortal(newSVnv(0)));
#endif
#ifdef HAS_PW_CLASS
		XPUSHs(sv_2mortal(newSVpv(p->pw_class?p->pw_class:"",0)));
#else
		XPUSHs(sv_2mortal(newSVpv("",0)));
#endif
		XPUSHs(sv_2mortal(newSVpv(p->pw_gecos?p->pw_gecos:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_dir?p->pw_dir:"",0)));
		XPUSHs(sv_2mortal(newSVpv(p->pw_shell?p->pw_shell:"",0)));
#ifdef HAS_PW_EXPIRE
		XPUSHs(sv_2mortal(newSVnv(p->pw_expire)));
#else
		XPUSHs(sv_2mortal(newSVnv(0)));
#endif
	}


int
setpassent(stayopen)
	int stayopen;
    PROTOTYPE: $
    CODE:
	RETVAL = setpassent(stayopen);
    OUTPUT:
	RETVAL

void
setpwent()
     PROTOTYPE:
     CODE:
	setpwent();

void
endpwent()
      PROTOTYPE: 
      CODE:
	endpwent();

SV *
hash(user, ...)
	char *user
   PROTOTYPE: $;$
   PREINIT:
     char *path = "";
     STRLEN n_a;
   INIT:
     char *mem;
   CODE:
     hparam(NULL);
     ST(0) = sv_newmortal();
     if (items > 1) {
       path = (char *)SvPV(ST(1), n_a);
     }
     mem = hexpand_home(user, path);
     sv_setpv(ST(0), mem);
     free(mem);

SV *
rewrite(user)
     char *user
   PROTOTYPE: $
   INIT:
     char *mem;
   CODE:
     ST(0) = sv_newmortal();
     mem = home_canon(user);
     sv_setpv(ST(0), mem);
     free(mem);
