/*

  Copyright 2000, 2001, 2002 Laurent Wacrenier

  This file is part of libhome

  libhome is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  libhome is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with libhome; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA

*/

#include "config.h"

static char const rcsid[] UNUSED =
"$Id: cleanup.c,v 1.11 2005/02/10 14:29:58 lwa Exp $";

#include <hparam.h>
#include <stdio.h>

extern void cache_clean(void);
extern void rewritedb_clean(void);
extern void home_clean(void);

void home_cleanup(void) {
  extern struct param home_param;

  
  if (home_param.driver && home_param.driver->clean) 
    home_param.driver->clean();
#if WITH_DB
  cache_clean();
  rewritedb_clean();
#endif
  home_clean();
}
