/*

  Copyright 2000, 2001, 2002 Laurent Wacrenier

  This file is part of libhome

  libhome is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  libhome is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with libhome; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA

*/

#include "config.h"

static char const rcsid[] UNUSED =
"$Id: rewritedb.c,v 1.8 2005/02/10 14:29:59 lwa Exp $";

#include <string.h>
#include <stdlib.h>
#include <db.h>

#include <hparam.h>

static DB **dblist=NULL;

char *rewritedb(char *user) {
  extern struct param home_param;

  char **dbfile = home_param.rewritedb;
  size_t len;

  if (dbfile == NULL) {
    return user;
  }

  if (dblist == NULL) {
    char **c=dbfile;
    while(*c) c++;
    dblist = (DB**)calloc( c-dbfile, sizeof(DB*) );
    if (dblist==NULL) {
      hmalloc_error("rewritedb", "dblist");
      return NULL;
    }
  }

  len = strlen(user);

  while(*dbfile) {
    DBT key = {};
    DBT value = {};
    int ret;
    int n = dbfile - home_param.rewritedb;
    if (dblist[n] == NULL) {
      if ((ret=db_create(dblist+n, NULL, 0))!=0) {
	home_retry("db_create: %s", db_strerror(ret));
	return NULL;
      }
#if DB_VERSION_MAJOR == 3 || (DB_VERSION_MAJOR == 4 && DB_VERSION_MINOR == 0)
      if ((ret=dblist[n]->open(dblist[n], *dbfile, 
			       NULL, DB_UNKNOWN, DB_RDONLY, 0)) != 0)
#else
      if ((ret=dblist[n]->open(dblist[n], NULL, *dbfile, 
			       NULL, DB_UNKNOWN, DB_RDONLY, 0)) != 0)
#endif
	{
	  home_error("DB->open(%s): %s", *dbfile, db_strerror(ret));
	  dblist[n]->close(dblist[n], 0);
	  dblist[n]=NULL;
	  dbfile++;
	  continue;
	}
    }
    key.data=user;
    key.size=len;

    value.data=NULL;
    value.flags=DB_DBT_MALLOC;

    ret=dblist[n]->get(dblist[n], NULL, &key, &value, 0);
    if (ret==0) {
      free(user);
      user=value.data;
      len=value.size;
    }

    dbfile++;
  }
  user=realloc(user, len+1);
  if (user == NULL) {
    hmalloc_error("rewritedb", "user");
    return NULL;
  }
  user[len]=0;

  return user;
}

void rewritedb_clean() {
  char **dbfile;
  extern struct param home_param;

  if (dblist==NULL)
    return ;

  dbfile = home_param.rewritedb;
  while(*dbfile) {
    int n = dbfile - home_param.rewritedb;
    if (dblist[n] != NULL) 
      dblist[n]->close(dblist[n], 0);
    dbfile++;
  }
  free(dblist);
  dblist=NULL;
  return;
}
