/*

  Copyright 2000, 2001, 2002 Laurent Wacrenier

  This file is part of libhome

  libhome is free software; you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  libhome is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with libhome; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA

*/

#include "config.h"

static char const rcsid[] UNUSED =
"$Id: tools.c,v 1.13 2005/02/10 14:29:59 lwa Exp $";

#define passwd system_passwd
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#undef passwd

#include "hparam.h"

struct passwd *home_getpwd(void) {
  static struct passwd pwd = {0,};

  if (pwd.pw_name) {
    free(pwd.pw_name);
    pwd.pw_name=NULL;
  }
  if (pwd.pw_passwd) {
    free(pwd.pw_passwd);
    pwd.pw_passwd=NULL;
  }
  if (pwd.pw_dir) {
    free(pwd.pw_dir);
    pwd.pw_dir=NULL;
  }
#ifdef HAS_PW_CLASS
  if (pwd.pw_class) {
    free(pwd.pw_class);
    pwd.pw_class=NULL;
  }
#endif
  if (pwd.pw_shell) {
    free(pwd.pw_shell);
    pwd.pw_shell=NULL;
  }
  if (pwd.pw_gecos) {
    free(pwd.pw_gecos);
    pwd.pw_gecos=NULL;
  }
#ifdef HAS_PW_QUOTA
  pwd.pw_quota=0;
#endif
#ifdef HAS_PW_CHANGE
  pwd.pw_change=0;
#endif
#ifdef HAS_PW_EXPIRE
  pwd.pw_expire=0;
#endif
#ifdef HAS_PW_FIELDS
  /* internal FreeBSD */
#endif

  return &pwd;
}

time_t home_expire(char *s) {
  extern struct param home_param;
#if HAVE_STRPTIME
  char *xs;
  struct tm t={0,};
#endif
  if (s==NULL || *s==0) {
    return 0;
  }
  if (home_param.expire_fmt == NULL || *(home_param.expire_fmt)==0) {
    return strtoul(s, NULL, 10);
  }
#if HAVE_STRPTIME
  if ((xs=strptime(s, home_param.expire_fmt, &t))!=NULL) {
    return mktime(&t);
  }
#endif
  return 0;
}

#if WITH_CHECKPASSWD
int home_checkpasswd(char *claimedpassword, char *cryptedpassword )
/* Check user password with multiple encoding schemes */
/* Return 0 if failed */
{
  char *ptrstart;

  /* Check user password */
  if (!strncasecmp(cryptedpassword,"{crypt}",7)) {
    /* Unix Crypt */
    ptrstart=strchr(cryptedpassword,'}')+1;
    /* Null password not allowed */
    if (*ptrstart==0) return 0; 
    if (*claimedpassword==0) return 0;
    return !strcmp(ptrstart,crypt(claimedpassword,ptrstart));
  }
  else if (!strncasecmp(cryptedpassword,"{md5}",5)) {
    /* MD5 */
    /* Not implemented yet */
    return 0; 
  }
  else {
    /* Plain text */
    return(!strcmp(claimedpassword,cryptedpassword));
  }
}
#endif
