/*
 * @file libleaftag/db-priv.h Database functions
 *
 * @Copyright (C) 2005-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LEAFTAG_DB_PRIV_H_
#define _LEAFTAG_DB_PRIV_H_

#include <glib.h>
#include <sqlite.h>

typedef struct
{
	GHashTable *cols;

} LtDbRow;

typedef struct
{
	GList *rows;

} LtDbResults;

LtDbResults *lt_db_query(const char *sql, ...);
void lt_db_exec(const char *sql, ...);
void lt_db_dump_results(LtDbResults *results);
sqlite *lt_get_db(void);

const char *lt_db_row_get(LtDbRow *row, const char *key);

void lt_db_results_destroy(LtDbResults *results);

char *lt_db_prepend_col_prefix(const char *prefix, const char *colname);

char *lt_db_build_multiple_where_clause(const char *col_prefix,
										const char *column, GList *items);
char *lt_db_build_sources_where_clause(GList *uris, const char *col_prefix);
char *lt_db_build_tags_where_clause(GList *tags, const char *col_prefix);

#endif /* _LEAFTAG_DB_PRIV_H_ */
