/*
 * @file libleaftag/object.h Base object
 *
 * @Copyright (C) 2005-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LEAFTAG_OBJECT_H_
#define _LEAFTAG_OBJECT_H_

#include <glib.h>
#include <glib-object.h>

typedef struct _LtObject      LtObject;
typedef struct _LtObjectPriv  LtObjectPriv;
typedef struct _LtObjectClass LtObjectClass;

struct _LtObject
{
	GObject parent_object;
	LtObjectPriv *priv;
};

struct _LtObjectClass
{
	GObjectClass parent_class;

	/* Signals*/
	void (*deleted)(LtObject *obj);

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

#define LT_TYPE_OBJECT            (lt_object_get_type())
#define LT_OBJECT(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), LT_TYPE_OBJECT, LtObject))
#define LT_OBJECT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), LT_TYPE_OBJECT, LtObjectClass))
#define LT_IS_OBJECT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), LT_TYPE_OBJECT))
#define LT_IS_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), LT_TYPE_OBJECT))
#define LT_OBJECT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), LT_TYPE_OBJECT, LtObjectClass))

GType lt_object_get_type(void);
guint lt_object_get_id(const LtObject *obj);
gboolean lt_object_get_in_db(const LtObject *obj);
void lt_free_object_list(GList *list);

#endif /* _LEAFTAG_OBJECT_H_ */
