/*
 * @file libleaftag/priv.h Private functions
 *
 * @Copyright (C) 2005-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LEAFTAG_PRIV_H_
#define _LEAFTAG_PRIV_H_

#include <libleaftag/db.h>
#include <libleaftag/db-priv.h>
#include <libleaftag/source.h>
#include <libleaftag/tag.h>

void lt_object_set_id(LtObject *obj, guint id);
void lt_object_set_in_db(LtObject *obj, gboolean in_db);

void lt_uri_parse(const char *uri, char **out_schema, char **out_path);
char *lt_uri_normalize(const char *uri);

LtSource *lt_create_source_from_row(LtDbRow *row, const char *col_prefix);
LtTag *lt_create_tag_from_row(LtDbRow *row, const char *col_prefix);

GList *lt_gather_sources_from_results(LtDbResults *results,
									  const char *col_prefix);
GList *lt_gather_tags_from_results(LtDbResults *results,
								   const char *col_prefix);

LtTag *lt_tag_new(const char *name);
LtSource *lt_source_new(const char *uri);

void lt_source_ensure_in_db(LtSource *source);
void lt_tag_ensure_in_db(LtTag *tag);

GList *lt_source_lookup_by_sql(const char *where, ...);
GList *lt_tag_lookup_by_sql(const char *where, ...);

#endif /* _LEAFTAG_PRIV_H_ */
