/*
 * @file libleaftag/source.h Source object and functions
 *
 * @Copyright (C) 2005-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LEAFTAG_SOURCE_H_
#define _LEAFTAG_SOURCE_H_

#include <libleaftag/object.h>

typedef struct _LtSource      LtSource;
typedef struct _LtSourcePriv  LtSourcePriv;
typedef struct _LtSourceClass LtSourceClass;

struct _LtSource
{
	LtObject parent_object;
	LtSourcePriv *priv;
};

struct _LtSourceClass
{
	LtObjectClass parent_class;

	/* Signals */
	void (*tags_changed)(LtSource *source);

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

#define LT_TYPE_SOURCE            (lt_source_get_type())
#define LT_SOURCE(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), LT_TYPE_SOURCE, LtSource))
#define LT_SOURCE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), LT_TYPE_SOURCE, LtSourceClass))
#define LT_IS_SOURCE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), LT_TYPE_SOURCE))
#define LT_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), LT_TYPE_SOURCE))
#define LT_SOURCE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), LT_TYPE_SOURCE, LtSourceClass))

GType lt_source_get_type(void);

LtSource *lt_create_source(const char *uri);
LtSource *lt_source_lookup(const char *uri);
GList *lt_source_lookup_many(GList *uris);

void lt_source_delete(LtSource *source);

void lt_source_set_uri(LtSource *source, const char *new_uri);
const char *lt_source_get_uri(const LtSource *source);

const char *lt_source_get_filename(const LtSource *source);

const char *lt_source_get_schema(const LtSource *source);

void lt_source_tag(LtSource *source, GList *tags);

void lt_source_tag_with_names(LtSource *source, GList *tag_names);

void lt_source_untag(LtSource *source, GList *tags);

void lt_source_untag_with_names(LtSource *source, GList *tag_names);

GList *lt_source_get_tags(const LtSource *source);

GList *lt_get_all_sources(void);

GList *lt_get_sources_with_schema(const char *schema);

GList *lt_get_sources_with_tags(GList *tags, const char *schema);

GList *lt_get_sources_with_tag_names(GList *tag_names, const char *schema);

#endif /* _LEAFTAG_SOURCE_H_ */
