/*
 * @file libleaftag/tag.h Tag object and functions
 *
 * @Copyright (C) 2005-2006 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LEAFTAG_TAG_H_
#define _LEAFTAG_TAG_H_

#include <libleaftag/object.h>

typedef struct _LtTag      LtTag;
typedef struct _LtTagPriv  LtTagPriv;
typedef struct _LtTagClass LtTagClass;

struct _LtTag
{
	LtObject parent_object;
	LtTagPriv *priv;
};

struct _LtTagClass
{
	LtObjectClass parent_class;

	/* Signals */
	void (*sources_changed)(LtTag *tag);

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

#define LT_TYPE_TAG            (lt_tag_get_type())
#define LT_TAG(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), LT_TYPE_TAG, LtTag))
#define LT_TAG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), LT_TYPE_TAG, LtTagClass))
#define LT_IS_TAG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), LT_TYPE_TAG))
#define LT_IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), LT_TYPE_TAG))
#define LT_TAG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), LT_TYPE_TAG, LtTagClass))

GType lt_tag_get_type(void);
LtTag *lt_create_tag(const char *tag_name);
LtTag *lt_tag_lookup(const char *tag_name);
GList *lt_tag_lookup_many(GList *tag_names);
void lt_tag_delete(LtTag *tag);

const char *lt_tag_get_name(const LtTag *tag);

void lt_tag_set_hidden(LtTag *tag, gboolean hidden);
gboolean lt_tag_get_hidden(const LtTag *tag);

void lt_tag_set_description(LtTag *tag, const char *description);
const char *lt_tag_get_description(const LtTag *tag);

void lt_tag_set_image(LtTag *tag, const char *image_path);
const char *lt_tag_get_image(const LtTag *tag);

GList *lt_tag_get_sources(const LtTag *tag, const char *schema);

GList *lt_get_all_tags(void);

GList *lt_get_visible_tags(void);

gboolean lt_get_tag_name_valid(const char *tag_name);

gboolean lt_get_tag_names_valid(GList *tag_names);

#endif /* _LEAFTAG_TAG_H_ */
