/* MCVE v3.x C API
   (c) 2002 by Main Street Softworks, Inc.
   Written by Brad House

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/

#include "libmonetra_main.h"
#include "monetra.h"

long M_Count_CD_Lines(M_CONN *myconn, long identifier)
{
  _M_CONN *conn=(_M_CONN *)myconn[0];
  char *temp, *str;
  M_QUEUE *ptr=(M_QUEUE *)identifier;
  long cnt=0;

  if (ptr->response == NULL) return(0);
  str=ptr->response;
  while (1) {
    temp=strstr(str, "\r\n");
    if (temp == NULL) break;
    cnt++;
    str=temp+2;
  }
  return(cnt);
}

char *M_Get_CD_Line(char *string)
{
  char *temp;
  int len;
  if (string == NULL) return(NULL);
  temp=strstr(string, "\r\n");
  if (temp == NULL) return(NULL);
  len=strlen(string)-strlen(temp);
  return(M_midstr(string, 0, len));
}

int M_Count_CD_Columns(M_CONN *myconn, long identifier)
{
  _M_CONN *conn=(_M_CONN *)myconn[0];
  char *temp;
  char *line, *str;
  M_QUEUE *ptr=(M_QUEUE *)identifier;
  int cnt=1;

  line=M_Get_CD_Line(ptr->response);
  if (line == NULL) return(0);
  str=line;
  while (1) {
    temp=strchr(str, ',');
    if (temp == NULL) break;
    str=temp+1;
    cnt++;
  }
  free(line);
  return(cnt);
}

