/* MCVE v3.x C API
   (c) 2002 by Main Street Softworks, Inc.
   Written by Brad House

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/
#include <sys/stat.h>
#include "libmonetra_main.h"
#include "monetra.h"

long M_FileSize(FILE *fp)
{
  long pos, len;
  pos=ftell(fp);
  fseek(fp, 0L, SEEK_END);
  len=ftell(fp);
  fseek(fp, pos, SEEK_SET);
  return(len);
}

#if 0
long M_ReturnFiles(char ***filenames, char *directory)
{
  long files=0;

#ifdef WIN32
  struct _finddata_t c_file;
  long hFile;
  char find[250];

  filenames[0]=NULL;
  strcpy(find, directory);
  if (directory[strlen(find)-1] != '\\')
    strcat(find, "\\");
  strcat(find, "*.rtn");
  if ((hFile = _findfirst(find, &c_file)) == -1L) return(0);
  filenames[0]=(char **)realloc(filenames[0], (files+1)*sizeof(char*));
  filenames[0][files]=(char *)malloc(251*sizeof(char));
  memset(filenames[0][files], 0, 251);
  strncpy(filenames[0][files], c_file.name, 250);
  files++;
  while (_findnext(hFile, &c_file) == 0) {
    filenames[0]=(char **)realloc(filenames[0], (files+1)*sizeof(char*));
    filenames[0][files]=(char *)malloc(251*sizeof(char));
    memset(filenames[0][files], 0, 251);
    strncpy(filenames[0][files], c_file.name, 250);
    files++;
  }
  _findclose(hFile);
#else
  struct dirent *namelist;
  DIR *dir;
  char *ext;

  filenames[0]=NULL;
  dir=opendir(directory);
  if (dir == NULL) return(0);
  rewinddir(dir);
  while ((namelist=readdir(dir)) != NULL) {
    if (strlen(namelist->d_name) > 4)
       ext=namelist->d_name+(strlen(namelist->d_name)-4);
    else
      ext="";
    if (strcasecmp(ext, ".rtn") == 0) {
      filenames[0]=(char **)realloc(filenames[0], (files+1)*sizeof(char*));
      filenames[0][files]=(char *)malloc(251*sizeof(char));
      memset(filenames[0][files], 0, 251);
      strncpy(filenames[0][files], namelist->d_name, 250);
      files++;
    }
  }
  closedir(dir);
#endif
  return(files);
}
#endif

int M_Monitor_File(M_CONN *myconn)
{
  _M_CONN *conn=(_M_CONN *)myconn[0];
  char filename[255];
  struct stat st;
  char *transaction=NULL;
  long flen;
  M_QUEUE *ptr=NULL;
  FILE *fp;

  ptr=conn->queue;
  while (ptr != NULL) {
    if (ptr->status == M_PENDING) {
      strcpy(filename, conn->location);
      M_DoCatSlash(filename);
      strncat(filename, ptr->identifier, 255);
      strncat(filename, ".rtn", 255);
      /* File found */
      if (stat(filename, &st) == 0) {
        /* Make sure the file got a chance to be written */
        M_uwait(500000);
        fp=fopen(filename, "rb");
        if (fp == NULL) {
          //can't open that file ... yet anyhow
          continue;
        }
        flen=M_FileSize(fp);
	if (flen < 3) {
          /* File is too small to be valid ... will
	     probably actually be zero */
	  fclose(fp);
	  continue;
	}
        transaction=(char *)malloc(flen+2);
        memset(transaction, 0, flen+1);
        fread(transaction, flen,sizeof(char), fp);         // Read the contents to a buffer
        fclose(fp);

        M_ProcessResponse(myconn, ptr->identifier, transaction);

        free(transaction);
        unlink(filename);  // Delete the file so it won't read it again
      }
    }
    ptr=ptr->next;
    if (ptr == conn->queue) break;
  }
  return(1);
}

#if 0
int M_Monitor_File(M_CONN *myconn)
{
  _M_CONN *conn=(_M_CONN *)myconn[0];
  long files, i;
  char **filenames=NULL;
  char *transaction;
  char *identifier;
  char filename[250];
  long flen;
  FILE *fp;

  files=M_ReturnFiles(&filenames, conn->location);

  if (files)
#ifdef WIN32
    Sleep(2000);
#else
    sleep(2);
#endif
	/* Make sure all files in our queue here have
                 been completely written.  This needs to
                 be replaced one day with file locking */

  for (i=0; i<files; i++) {
    identifier=strdup(filenames[i]);
    identifier[strlen(identifier)-4]=0;
    strcpy(filename, conn->location);
    M_DoCatSlash(filename);
    strcat(filename, filenames[i]);

    fp=fopen(filename, "rb");
    if (fp == NULL) {
      //can't open that file ... yet anyhow
       free(identifier);
       continue;
    }
    flen=M_FileSize(fp);
    transaction=(char *)malloc(flen+2);
    memset(transaction, 0, flen+1);
    fread(transaction, flen,sizeof(char), fp);         // Read the contents to a buffer
    fclose(fp);

    M_ProcessResponse(myconn, identifier, transaction);

    free(identifier);
    free(transaction);
    unlink(filename);  // Delete the file so it won't read it again
    free(filenames[i]);
  }

  if (files > 0)
    free(filenames);
  return(1);
}
#endif

int M_SendTransaction_File(M_CONN *myconn, char *identifier, char *transaction)
{
   _M_CONN *conn=(_M_CONN *)myconn[0];
   char filename[300];
   FILE *fp;

   strcpy(filename, conn->location);
   M_DoCatSlash(filename);
   strcat(filename, identifier);
   strcat(filename, ".trn");
   fp=fopen(filename, "wb");
   if (fp == NULL) {
     return(0);
   }
   fwrite(transaction, strlen(transaction), 1, fp);
   fclose(fp);
   return(1);
}

