/* MCVE v3.x C API
   (c) 2002 by Main Street Softworks, Inc.
   Written by Brad House

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/

#include "libmonetra_main.h"
#include "monetra.h"

/* TRANSACTION ROUTINES */


long M_Sale(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                               char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL || (trackdata == NULL && (account == NULL || expdate == NULL)) || amount <= 0) {
    return(M_ERROR);
  }
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_SALE);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_TRACKDATA, trackdata);
  M_TransParam(myconn, identifier, MC_ACCOUNT, account);
  M_TransParam(myconn, identifier, MC_EXPDATE, expdate);
  M_TransParam(myconn, identifier, MC_STREET, street);
  M_TransParam(myconn, identifier, MC_ZIP, zip);
  M_TransParam(myconn, identifier, MC_CV, cv);
  M_TransParam(myconn, identifier, MC_AMOUNT, amount);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_PreAuth(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL || (trackdata == NULL && (account == NULL || expdate == NULL)) || amount <= 0)
    return(M_ERROR);


  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_PREAUTH);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_TRACKDATA, trackdata);
  M_TransParam(myconn, identifier, MC_ACCOUNT, account);
  M_TransParam(myconn, identifier, MC_EXPDATE, expdate);
  M_TransParam(myconn, identifier, MC_STREET, street);
  M_TransParam(myconn, identifier, MC_ZIP, zip);
  M_TransParam(myconn, identifier, MC_CV, cv);
  M_TransParam(myconn, identifier, MC_AMOUNT, amount);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}


long M_Void(M_CONN *myconn, char *username, char *password, M_int64 ttid, long ptrannum)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL || (ttid == -1 && ptrannum == -1))
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_VOID);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);

  if (ttid != -1)
    M_TransParam(myconn, identifier, MC_TTID, ttid);
  else if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}


long M_PreAuthCompletion(M_CONN *myconn, char *username, char *password, double finalamount, M_int64 ttid, long ptrannum)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL || finalamount <= 0 || (ttid == -1 && ptrannum == -1))
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_PREAUTHCOMPLETE);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_AMOUNT, finalamount);
  if (ttid != -1)
    M_TransParam(myconn, identifier, MC_TTID, ttid);
  else if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_Force(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                char *authcode, char *comments, char *clerkid, char *stationid, long ptrannum)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL || (trackdata == NULL && (account == NULL || expdate == NULL)) || amount <= 0)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_FORCE);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_TRACKDATA, trackdata);
  M_TransParam(myconn, identifier, MC_ACCOUNT, account);
  M_TransParam(myconn, identifier, MC_EXPDATE, expdate);
  M_TransParam(myconn, identifier, MC_AMOUNT, amount);
  M_TransParam(myconn, identifier, MC_APPRCODE, authcode);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_Return(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *comments, char *clerkid, char *stationid, long ptrannum)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (username == NULL || password == NULL || (trackdata == NULL && (account == NULL || expdate == NULL)) || amount <= 0)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_RETURN);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_TRACKDATA, trackdata);
  M_TransParam(myconn, identifier, MC_ACCOUNT, account);
  M_TransParam(myconn, identifier, MC_EXPDATE, expdate);
  M_TransParam(myconn, identifier, MC_AMOUNT, amount);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}


long M_Override(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (username == NULL || password == NULL || (trackdata == NULL && (account == NULL || expdate == NULL)) || amount <= 0)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_OVERRIDE);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_TRACKDATA, trackdata);
  M_TransParam(myconn, identifier, MC_ACCOUNT, account);
  M_TransParam(myconn, identifier, MC_EXPDATE, expdate);
  M_TransParam(myconn, identifier, MC_STREET, street);
  M_TransParam(myconn, identifier, MC_ZIP, zip);
  M_TransParam(myconn, identifier, MC_CV, cv);
  M_TransParam(myconn, identifier, MC_AMOUNT, amount);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}


long M_Settle(M_CONN *myconn, char *username, char *password, char *batch)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (username == NULL || password == NULL)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_SETTLE);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  if (batch == NULL || !strlen(batch)) {
    M_TransParam(myconn, identifier, MC_BATCH, "all");
  } else {
    M_TransParam(myconn, identifier, MC_BATCH, batch);
  }

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

/* USER-LEVEL ADMINISTRATIVE REQUESTS */

long M_Gut(M_CONN *myconn, char *username, char *password, int type, char *acct, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate)
{
  //_M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_ADMIN);
  M_TransParam(myconn, identifier, MC_ADMIN, MC_ADMIN_GUT);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_AUDITTYPE, type);
  M_TransParam(myconn, identifier, MC_ACCT, acct);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  M_TransParam(myconn, identifier, MC_BDATE, bdate);
  M_TransParam(myconn, identifier, MC_EDATE, edate);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}


long M_Gl(M_CONN *myconn, char *username, char *password, int type, char *acct, char *batch, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate)
{
  //_M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_ADMIN);
  M_TransParam(myconn, identifier, MC_ADMIN, MC_ADMIN_GL);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_AUDITTYPE, type);
  M_TransParam(myconn, identifier, MC_ACCT, acct);
  M_TransParam(myconn, identifier, MC_BATCH, batch);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  M_TransParam(myconn, identifier, MC_BDATE, bdate);
  M_TransParam(myconn, identifier, MC_EDATE, edate);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_Gft(M_CONN *myconn, char *username, char *password, int type, char *acct, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate)
{
  // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL)
    return(M_ERROR);
    
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_ADMIN);
  M_TransParam(myconn, identifier, MC_ADMIN, MC_ADMIN_GFT);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_AUDITTYPE, type);
  M_TransParam(myconn, identifier, MC_ACCT, acct);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  M_TransParam(myconn, identifier, MC_BDATE, bdate);
  M_TransParam(myconn, identifier, MC_EDATE, edate);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

/*
long M_Ub(M_CONN *myconn, char *username, char *password)
{
  _M_CONN *conn=(_M_CONN *)myconn[0];
  M_TRANS trans;
  M_ClearTransaction(&trans);
  if (username == NULL || password == NULL)
    return(M_ERROR);
  trans.trans_type=M_UB;
  trans.username=username;
  trans.password=password;
  return(M_SendTransaction(myconn, trans));
}
*/

long M_Rs(M_CONN *myconn, char *username, char *password, char *stationid)
{
  //_M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL || stationid == NULL)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_ADMIN);
  M_TransParam(myconn, identifier, MC_ADMIN, MC_ADMIN_RS);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_Qc(M_CONN *myconn, char *username, char *password, char *clerkid, char *stationid, char *comments, double ptrannum)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_ADMIN);
  M_TransParam(myconn, identifier, MC_ADMIN, MC_ADMIN_QC);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_CLERKID, clerkid);
  M_TransParam(myconn, identifier, MC_STATIONID, stationid);
  M_TransParam(myconn, identifier, MC_COMMENTS, comments);
  if (ptrannum != -1)
    M_TransParam(myconn, identifier, MC_PTRANNUM, ptrannum);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);

}

long M_Chkpwd(M_CONN *myconn, char *username, char *password)
{
  //_M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  if (username == NULL || password == NULL)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_CHKPWD);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_Bt(M_CONN *myconn, char *username, char *password)
{
  //_M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (username == NULL || password == NULL)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_ADMIN);
  M_TransParam(myconn, identifier, MC_ADMIN, MC_ADMIN_BT);
  M_TransParam(myconn, identifier, MC_USERNAME, username);
  M_TransParam(myconn, identifier, MC_PASSWORD, password);

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

/* ENGINE-ADMIN REQUESTS */


long M_Chngpwd(M_CONN *myconn, char *adminpassword, char *newpassword)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (adminpassword == NULL || newpassword == NULL)
    return(M_ERROR);

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_CHNGPWD);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpassword);
  M_TransParam(myconn, identifier, MC_PWD, newpassword);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_ListUsers(M_CONN *myconn, char *password)
{
  //  _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (password == NULL)
    return(M_ERROR);
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_LISTUSERS);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_EnableUser(M_CONN *myconn, char *adminpwd, char *user)
{
  // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (adminpwd == NULL || user == NULL)
    return(M_ERROR);
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_ENABLEUSER);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpwd);
  M_TransParam(myconn, identifier, MC_USER, user);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_DisableUser(M_CONN *myconn, char *adminpwd, char *user)
{
  // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (adminpwd == NULL || user == NULL)
    return(M_ERROR);
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_DISABLEUSER);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpwd);
  M_TransParam(myconn, identifier, MC_USER, user);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}


long M_GetUserInfo(M_CONN *myconn, char *adminpwd, char *user)
{
  long identifier;
  if (adminpwd == NULL || user == NULL)
    return(M_ERROR);
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_GETUSERINFO);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpwd);
  M_TransParam(myconn, identifier, MC_USER, user);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_DelUser(M_CONN *myconn, char *password, char *user)
{
  long identifier;
  if (password == NULL || user == NULL)
    return(M_ERROR);
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_DELUSER);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, password);
  M_TransParam(myconn, identifier, MC_USER, user);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_ListStats(M_CONN *myconn, char *adminpwd)
{
  //_M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (adminpwd == NULL)
    return(M_ERROR);
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_LISTSTATS);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpwd);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_Export(M_CONN *myconn, char *adminpwd, char *filename)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (filename == NULL || adminpwd == NULL)
    return(M_ERROR);
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_EXPORT);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpwd);
  M_TransParam(myconn, identifier, MC_FILE, filename);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

long M_Import(M_CONN *myconn, char *adminpwd, char *filename)
{
 // _M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;
  if (filename == NULL || adminpwd == NULL)
    return(M_ERROR);
  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_IMPORT);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpwd);
  M_TransParam(myconn, identifier, MC_FILE, filename);
  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

/* LEGACY USER FUNCTIONS */

typedef struct _UserSetup {
  char *proc;
  char *user;
  char *pwd;
  char *indcode;
  char *merchid;
  char *bankid;
  char *termid;
  char *clientnum;
  char *storeid;
  char *agentid;
  char *chainid;
  char *zipcode;
  char *timezone;
  char *merchcat;
  char *mername;
  char *merchloc;
  char *statecode;
  char *servicephone;
} _UserSetup;

void M_InitUserSetup(M_UserSetup *setup)
{

  _UserSetup *usersetup;
  setup[0]=(M_UserSetup)malloc(sizeof(_UserSetup)*1);
  usersetup=(_UserSetup *)setup[0];
  usersetup->proc=NULL;
  usersetup->user=NULL;
  usersetup->pwd=NULL;
  usersetup->indcode=NULL;
  usersetup->merchid=NULL;
  usersetup->bankid=NULL;
  usersetup->termid =NULL;
  usersetup->clientnum =NULL;
  usersetup->storeid =NULL;
  usersetup->agentid =NULL;
  usersetup->chainid =NULL;
  usersetup->zipcode =NULL;
  usersetup->timezone =NULL;
  usersetup->merchcat =NULL;
  usersetup->mername =NULL;
  usersetup->merchloc =NULL;
  usersetup->statecode =NULL;
  usersetup->servicephone =NULL;
}

int M_AddUserArg(M_UserSetup *setup, int argtype, char *argval)
{
  _UserSetup *usersetup=(_UserSetup *)setup[0];

  char **field;

  if (argtype == M_PROC)
    field=&usersetup->proc;
  else if (argtype == M_USER)
    field=&usersetup->user;
  else if (argtype == M_PWD)
    field=&usersetup->pwd;
  else if (argtype == M_INDCODE)
    field=&usersetup->indcode;
  else if (argtype == M_MERCHID)
    field=&usersetup->merchid;
  else if (argtype == M_BANKID)
    field=&usersetup->bankid;
  else if (argtype == M_TERMID)
    field=&usersetup->termid;
  else if (argtype == M_CLIENTNUM)
    field=&usersetup->clientnum;
  else if (argtype == M_STOREID)
    field=&usersetup->storeid;
  else if (argtype == M_AGENTID)
    field=&usersetup->agentid;
  else if (argtype == M_CHAINID)
    field=&usersetup->chainid;
  else if (argtype == M_ZIPCODE)
    field=&usersetup->zipcode;
  else if (argtype == M_TIMEZONE)
    field=&usersetup->timezone;
  else if (argtype == M_MERCHCAT)
    field=&usersetup->merchcat;
  else if (argtype == M_MERNAME)
    field=&usersetup->mername;
  else if (argtype == M_MERCHLOC)
    field=&usersetup->merchloc;
  else if (argtype == M_STATECODE)
    field=&usersetup->statecode;
  else if (argtype == M_SERVICEPHONE)
    field=&usersetup->servicephone;
  else
    return(0);

  field[0]=(char *)malloc((strlen(argval)+1)*sizeof(char));
  strcpy(field[0], argval);
  return(1);
}


void M_DeleteUserSetup(M_UserSetup *setup)
{
  _UserSetup *usersetup=(_UserSetup *)setup[0];

  if (usersetup->proc != NULL) {
    free(usersetup->proc);
    usersetup->proc=NULL;
  }
  if (usersetup->user != NULL) {
    free(usersetup->user);
    usersetup->user=NULL;
  }
  if (usersetup->pwd != NULL) {
    free(usersetup->pwd);
    usersetup->pwd=NULL;
  }
  if (usersetup->indcode != NULL) {
    free(usersetup->indcode);
    usersetup->indcode=NULL;
  }
  if (usersetup->merchid != NULL) {
    free(usersetup->merchid);
    usersetup->merchid=NULL;
  }
  if (usersetup->bankid != NULL) {
    free(usersetup->bankid);
    usersetup->bankid=NULL;
  }
  if (usersetup->termid != NULL) {
    free(usersetup->termid);
    usersetup->termid=NULL;
  }
  if (usersetup->clientnum != NULL) {
    free(usersetup->clientnum);
    usersetup->clientnum=NULL;
  }
  if (usersetup->storeid != NULL) {
    free(usersetup->storeid);
    usersetup->storeid=NULL;
  }
  if (usersetup->agentid != NULL) {
    free(usersetup->agentid);
    usersetup->agentid=NULL;
  }
  if (usersetup->chainid != NULL) {
    free(usersetup->chainid);
    usersetup->chainid=NULL;
  }
  if (usersetup->zipcode != NULL) {
    free(usersetup->zipcode);
    usersetup->zipcode=NULL;
  }
  if (usersetup->timezone != NULL) {
    free(usersetup->timezone);
    usersetup->timezone=NULL;
  }
  if (usersetup->merchcat != NULL) {
    free(usersetup->merchcat);
    usersetup->merchcat=NULL;
  }
  if (usersetup->mername != NULL) {
    free(usersetup->mername);
    usersetup->mername=NULL;
  }
  if (usersetup->merchloc != NULL) {
    free(usersetup->merchloc);
    usersetup->merchloc=NULL;
  }
  if (usersetup->statecode != NULL) {
    free(usersetup->statecode);
    usersetup->statecode=NULL;
  }
  if (usersetup->servicephone != NULL) {
    free(usersetup->servicephone);
    usersetup->servicephone=NULL;
  }
  free(setup[0]);
}

long M_AddUser(M_CONN *myconn, char *adminpwd, M_UserSetup *setup)
{
  _UserSetup *usersetup=(_UserSetup *)setup[0];
  //_M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_ADDUSER);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpwd);

  if (usersetup->proc != NULL) {
    M_TransParam(myconn, identifier, MC_USER_PROC, usersetup->proc);
  }
  if (usersetup->user != NULL) {
    M_TransParam(myconn, identifier, MC_USER_USER, usersetup->user);
  }
  if (usersetup->pwd != NULL) {
    M_TransParam(myconn, identifier, MC_USER_PWD, usersetup->pwd);
  }
  if (usersetup->indcode != NULL) {
    M_TransParam(myconn, identifier, MC_USER_INDCODE, usersetup->indcode);
  }
  if (usersetup->merchid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_MERCHID, usersetup->merchid);
  }
  if (usersetup->bankid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_BANKID, usersetup->bankid);
  }
  if (usersetup->termid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_TERMID, usersetup->termid);
  }
  if (usersetup->clientnum != NULL) {
    M_TransParam(myconn, identifier, MC_USER_CLIENTNUM, usersetup->clientnum);
  }
  if (usersetup->storeid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_STOREID, usersetup->storeid);
  }
  if (usersetup->agentid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_AGENTID, usersetup->agentid);
  }
  if (usersetup->chainid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_CHAINID, usersetup->chainid);
  }
  if (usersetup->zipcode != NULL) {
    M_TransParam(myconn, identifier, MC_USER_ZIPCODE, usersetup->zipcode);
  }
  if (usersetup->timezone != NULL) {
    M_TransParam(myconn, identifier, MC_USER_TIMEZONE, usersetup->timezone);
  }
  if (usersetup->merchcat != NULL) {
    M_TransParam(myconn, identifier, MC_USER_MERCHCAT, usersetup->merchcat);
  }
  if (usersetup->mername != NULL) {
    M_TransParam(myconn, identifier, MC_USER_MERNAME, usersetup->mername);
  }
  if (usersetup->merchloc != NULL) {
    M_TransParam(myconn, identifier, MC_USER_MERCHLOC, usersetup->merchloc);
  }
  if (usersetup->statecode != NULL) {
    M_TransParam(myconn, identifier, MC_USER_STATECODE, usersetup->statecode);
  }
  if (usersetup->servicephone != NULL) {
    M_TransParam(myconn, identifier, MC_USER_PHONE, usersetup->servicephone);
  }

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

char *M_GetUserArg(M_UserSetup *setup, int argtype)
{
  _UserSetup *usersetup=(_UserSetup *)setup[0];
  char *field;

  if (argtype == M_PROC)
    field=usersetup->proc;
  else if (argtype == M_USER)
    field=usersetup->user;
  else if (argtype == M_PWD)
    field=usersetup->pwd;
  else if (argtype == M_INDCODE)
    field=usersetup->indcode;
  else if (argtype == M_MERCHID)
    field=usersetup->merchid;
  else if (argtype == M_BANKID)
    field=usersetup->bankid;
  else if (argtype == M_TERMID)
    field=usersetup->termid;
  else if (argtype == M_CLIENTNUM)
    field=usersetup->clientnum;
  else if (argtype == M_STOREID)
    field=usersetup->storeid;
  else if (argtype == M_AGENTID)
    field=usersetup->agentid;
  else if (argtype == M_CHAINID)
    field=usersetup->chainid;
  else if (argtype == M_ZIPCODE)
    field=usersetup->zipcode;
  else if (argtype == M_TIMEZONE)
    field=usersetup->timezone;
  else if (argtype == M_MERCHCAT)
    field=usersetup->merchcat;
  else if (argtype == M_MERNAME)
    field=usersetup->mername;
  else if (argtype == M_MERCHLOC)
    field=usersetup->merchloc;
  else if (argtype == M_STATECODE)
    field=usersetup->statecode;
  else if (argtype == M_SERVICEPHONE)
    field=usersetup->servicephone;
  else
    return(NULL);
  return(field);
}

long M_EditUser(M_CONN *myconn, char *adminpwd, M_UserSetup *setup)
{
  _UserSetup *usersetup=(_UserSetup *)setup[0];
  //_M_CONN *conn=(_M_CONN *)myconn[0];
  long identifier;

  identifier=M_TransNew(myconn);
  M_TransParam(myconn, identifier, MC_TRANTYPE, MC_TRAN_EDITUSER);
  M_TransParam(myconn, identifier, MC_USERNAME, "MCVEADMIN");
  M_TransParam(myconn, identifier, MC_PASSWORD, adminpwd);

  if (usersetup->proc != NULL) {
    M_TransParam(myconn, identifier, MC_USER_PROC, usersetup->proc);
  }
  if (usersetup->user != NULL) {
    M_TransParam(myconn, identifier, MC_USER_USER, usersetup->user);
  }
  if (usersetup->pwd != NULL) {
    M_TransParam(myconn, identifier, MC_USER_PWD, usersetup->pwd);
  }
  if (usersetup->indcode != NULL) {
    M_TransParam(myconn, identifier, MC_USER_INDCODE, usersetup->indcode);
  }
  if (usersetup->merchid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_MERCHID, usersetup->merchid);
  }
  if (usersetup->bankid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_BANKID, usersetup->bankid);
  }
  if (usersetup->termid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_TERMID, usersetup->termid);
  }
  if (usersetup->clientnum != NULL) {
    M_TransParam(myconn, identifier, MC_USER_CLIENTNUM, usersetup->clientnum);
  }
  if (usersetup->storeid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_STOREID, usersetup->storeid);
  }
  if (usersetup->agentid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_AGENTID, usersetup->agentid);
  }
  if (usersetup->chainid != NULL) {
    M_TransParam(myconn, identifier, MC_USER_CHAINID, usersetup->chainid);
  }
  if (usersetup->zipcode != NULL) {
    M_TransParam(myconn, identifier, MC_USER_ZIPCODE, usersetup->zipcode);
  }
  if (usersetup->timezone != NULL) {
    M_TransParam(myconn, identifier, MC_USER_TIMEZONE, usersetup->timezone);
  }
  if (usersetup->merchcat != NULL) {
    M_TransParam(myconn, identifier, MC_USER_MERCHCAT, usersetup->merchcat);
  }
  if (usersetup->mername != NULL) {
    M_TransParam(myconn, identifier, MC_USER_MERNAME, usersetup->mername);
  }
  if (usersetup->merchloc != NULL) {
    M_TransParam(myconn, identifier, MC_USER_MERCHLOC, usersetup->merchloc);
  }
  if (usersetup->statecode != NULL) {
    M_TransParam(myconn, identifier, MC_USER_STATECODE, usersetup->statecode);
  }
  if (usersetup->servicephone != NULL) {
    M_TransParam(myconn, identifier, MC_USER_PHONE, usersetup->servicephone);
  }

  if (!M_TransSend(myconn, identifier))
    return(-1);
  return(identifier);
}

