/* MCVE v3.x C API
   (c) 2002 by Main Street Softworks, Inc.
   Written by Brad House

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/

#include "libmonetra_main.h"
#include "monetra.h"


void M_init_locks(M_CONN *myconn)
{
	_M_CONN *conn=(_M_CONN *)(*myconn);
	if (conn->mutexreg != NULL) {
		conn->mutex=(*(conn->mutexreg))();
	}
}

void M_destroy_locks(M_CONN *myconn)
{
	_M_CONN *conn=(_M_CONN *)(*myconn);
	if (conn->mutex != NULL && conn->mutexunreg != NULL) {
		(*(conn->mutexunreg))(conn->mutex);
		conn->mutex=NULL;
	}
}

void M_lock(M_CONN *myconn)
{
	_M_CONN *conn=(_M_CONN *)(*myconn);
	if (conn->mutex != NULL && conn->mutexlock != NULL) {
		(*(conn->mutexlock))(conn->mutex);
	}
}

void M_unlock(M_CONN *myconn)
{
	_M_CONN *conn=(_M_CONN *)(*myconn);
	if (conn->mutex != NULL && conn->mutexlock != NULL) {
		(*(conn->mutexlock))(conn->mutex);
	}
}

