/* MCVE v3.x C API
   (c) 2002 by Main Street Softworks, Inc.
   Written by Brad House

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/

#ifndef __LIBM_MAIN_H__
#define __LIBM_MAIN_H__


#include "monetra.h"

/* Standard includes ... all platforms */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <stdarg.h>
#include <errno.h>
#include <fcntl.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

/* Win32 includes */
#ifdef WIN32
#include <io.h>
#include <winsock2.h>
#include <sys/timeb.h>
#else /* !Win32 */
/* UNIX/POSIX includes */
#include <unistd.h>
#include <sys/socket.h>
#ifndef DISABLE_IP
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif
#include <sys/time.h>
#include <dirent.h>

#endif /* Win32 */


#ifdef ENABLE_SSL
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>
#endif

#ifndef HAVE_SOCKLEN_T
typedef int socklen_t;
#endif

typedef struct M_TRANS {
  char *key;
  char *value;
} M_TRANS;

typedef struct M_QUEUE {
  char identifier[31];
  int type;
  int admin;
  int status;

  /* Store outgoing transaction fields -- key/value pairs */
  int transaction_fields;
  M_TRANS *transaction;


  // Stuff read from return
  int code;
  int avs;
  int cv;
  char *auth;
  char *text;
  M_int64 tid;
  char *item;
  char *batch;
  
  int resp_fields;
  M_TRANS *parsed_resp;
  // Comma Delimited response storage
  char *response;
  int iscommadelimited;
  // storage
  char ***separated;
  int columns;
  int rows;
  
  void *next;
  void *prev;
} M_QUEUE;

#include "libmonetra_utils.h"
#include "libmonetra_misc.h"
#include "libmonetra_parsing.h"
#include "libmonetra_cdparsing.h"
#include "libmonetra_locking.h"
#include "libmonetra_sockets.h"
#include "libmonetra_file.h"
#include "libmonetra_strings.h"
#include "libmonetra_snprintf.h"


#ifdef WIN32
#define ioctl(a,b,c) ioctlsocket(a,b,c)
#endif


#define M_FILE 1
#define M_SOCKETS 2
#define M_SSL 3



#define M_DISCONNECTED 0
#define M_CONNECTED 1



typedef struct _M_CONN {
  int conn_method;  // Drop File, Sockets, SSL
  char location[251]; // Either Drop-File directory, or hostname
  unsigned short port;  // For IP and SSL, a port number
  int ptr;  // For IP and SSL, the pointer to an open connection
  char *inbuf;
  int inbuf_cnt;
  int inbuf_alloc;
  char *outbuf;
  int outbuf_cnt;
  int outbuf_alloc;
  
  int status;
  int do_debug;
  
  long timeout;
  int blocking;
  int verifyconn;
  int verifyssl;
  int max_conn_time;
  char *error_text;

#ifdef ENABLE_SSL
  SSL *ssl;
  X509 *server_cert;
#endif
  // int CA_verify;
  // char *CA_cert;  // To store an SSL certificate
  // char *CA_key;  // To store an SSL key
  long outstanding_auths;
  long queue_length;
  M_QUEUE *queue;
  
  M_Register_Mutex mutexreg;
  M_Mutex_Lock mutexlock;
  M_Mutex_Unlock mutexunlock;
  M_Unregister_Mutex mutexunreg;

  void *mutex;  
} _M_CONN;


/* Mac OS X 10.2 does not support atoll() but 10.3 does,
 * since we compile on 10.3, but need to support 10.2, 
 * disable ATOLL hard for __APPLE__ */
#if defined(NO_ATOLL) || defined(__APPLE__)
#if defined(NO_STRTOLL)
#define M_atoll(a) atol(a)
#else /* STRTOLL does exist */
#define M_atoll(a) strtoll(a, NULL, 10);
#endif /* NO_STRTOLL */
#else /* ATOLL does exist and we're !APPLE */
#define M_atoll(a) atoll(a)
#endif


#ifdef ENABLE_SSL
extern SSL_CTX *client_ctx;
#endif

int M_TransParam_Add(M_CONN *myconn, long identifier, char *key, char *value);

#define IP_BLOCK_SIZE 64*1024

#endif
