/* MCVE v3.x C API
   (c) 2002 by Main Street Softworks, Inc.
   Written by Brad House

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/

#include "libmonetra_main.h"
#include "monetra.h"

long M_GenerateSeed()
{
#ifdef WIN32
  struct _timeb timebuffer;
  _ftime(&timebuffer);
  return(timebuffer.millitm+(1000000*timebuffer.time));
#else
  struct timeval t;
  gettimeofday(&t, NULL);
  return(t.tv_usec+(1000000*t.tv_sec));
#endif
}

int M_DirectoryExists(char *directory)
{
#ifdef WIN32
  if ((_access(directory, 0)) != -1) return(0);
#else
  DIR *dir;
  dir=opendir(directory);
  if (dir==NULL) return(0);
  closedir(dir);
#endif
  return(1);
}

void M_DoCatSlash(char *string)
{
#ifdef WIN32
  if (string[strlen(string)-1] != '\\')
    strcat(string, "\\");
#else
  if (string[strlen(string)-1] != '/')
    strcat(string, "/");
#endif
}

char *M_midstr(char *string, int start, int length)
{
  char *temp=NULL, *ret=NULL;
  temp=string+start;
  ret=(char *)malloc(length+1);

  if (ret == NULL) return(NULL);
  strncpy(ret, temp, length);

  ret[length]=0;
  return(ret);
}

// Generate a random number which can be used in a filename if necessary
int M_RandSeed()
{
  long seed;
  seed=M_GenerateSeed();
  srand((unsigned int)seed);
  return(1);
}

int M_RandChar()
{
  int rand_num;
  int done=0;

  while (!done) {
     rand_num=48+rand()%74;
     if ((rand_num >=58 && rand_num <=63) || (rand_num >=92 && rand_num <= 96)) done=0;
     else done=1;
  }
  return(rand_num);
}

char *M_GenerateIdentifier()
{
  char *identifier;
  int i;
  identifier=(char *)malloc(21);
  M_RandSeed();
  for (i=0; i<20; i++) {
    identifier[i]=M_RandChar();
  }
  identifier[20]=0;
  return(identifier);
}


// Replacement for sleep() and usleep()
int M_uwait(unsigned long length)
{
   fd_set readfs;
   struct timeval timeout;

   timeout.tv_sec=length/(unsigned long) 1000000;
   timeout.tv_usec=(length % (unsigned long) 1000000);
   FD_ZERO(&readfs);
   select(0, &readfs, NULL, NULL, &timeout);
   return(1);
}

char *MC_SAFE_strncpy(char *dest, char *src, long len)
{
  if (src == NULL || !strlen(src)) {
    dest[0]=0;
  } else {
    strncpy(dest, src, len);
  }
  return(dest);
}

char *MC_SAFE_strdup(char *src)
{
  char *ret=NULL;
  if (src == NULL || !strlen(src)) {
    ret=malloc(1);
    ret[0]=0;
  } else {
    ret=strdup(src);
  }
  return(ret);
}



void M_Set_Conn_Error(M_CONN *myconn, char *error)
{
  _M_CONN *conn=(_M_CONN *)myconn[0];
  if (error != NULL && strlen(error)) {
    if (conn->error_text != NULL)
      free(conn->error_text);
    conn->error_text=NULL;
    conn->error_text=strdup(error);
  }
}
