#ifndef __LIBM_SNPRINTF__
#define __LIBM_SNPRINTF__

#include <stdarg.h>
#ifndef WIN32
#include <sys/ioctl.h>
#include <sys/param.h>
#endif
#include "monetra.h"

/*
 * We do all internal arithmetic in the widest available integer type,
 * here called long_long (or ulong_long for unsigned).
 */
#ifdef WIN32
typedef signed __int64 long_long;
typedef unsigned __int64 ulong_long;
#else
#ifndef NO_LONG_LONG
typedef long long long_long;
typedef unsigned long long ulong_long;
#else
typedef long long_long;
typedef unsigned long ulong_long;
#endif
#endif

/* SNPRINTF REPLACEMENT CALLS */
int M_snprintf(char *str, size_t count, const char *fmt,...);
int M_vsnprintf(char *str, size_t count, const char *fmt, va_list args);
int M_vasprintf(char **ret, const char *fmt, va_list args);
int M_asprintf(char **ret, const char *fmt, ...);
int M_vfprintf(FILE *fp, const char *fmt, va_list args);

#endif

