/* MCVE v3.x C API
   (c) 2002 by Main Street Softworks, Inc.
   Written by Brad House

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/

#include "libmonetra_main.h"
#include "monetra.h"

char *M_GetTypeString(int trans_type)
{
  char *type=NULL;

  switch(trans_type) {
    case MC_TRAN_SALE:
      type="SALE";
    break;
    case MC_TRAN_PREAUTH:
      type="PREAUTH";
    break;
    case MC_TRAN_VOID:
      type="VOID";
    break;
    case MC_TRAN_PREAUTHCOMPLETE:
      type="FORCE";
    break;
    case MC_TRAN_FORCE:
      type="FORCE";
    break;
    case MC_TRAN_OVERRIDE:
      type="OVERRIDE";
    break;
    case MC_TRAN_RETURN:
      type="RETURN";
    break;
    case MC_TRAN_SETTLE:
      type="SETTLE";
    break;
    case MC_TRAN_ADMIN:
      type="ADMIN";
    break;
    case MC_TRAN_CHKPWD:
      type="CHKPWD";
    break;
    case MC_TRAN_INCREMENTAL:
      type = "INCREMENTAL";
    break;
    case MC_TRAN_REVERSAL:
      type = "REVERSAL";
    break;
    case MC_TRAN_ACTIVATE:
      type = "ACTIVATE";
    break;
    case MC_TRAN_BALANCEINQ:
      type = "BALANCEINQ";
    break;
    case MC_TRAN_CASHOUT:
      type = "CASHOUT";
    break;
    case MC_TRAN_TOREVERSAL:
      type = "TOREVERSAL";
    break;
    case MC_TRAN_SETTLERFR:
      type = "SETTLERFR";
    break;
    case MC_TRAN_ISSUE:
      type = "ISSUE";
    break;
    case MC_TRAN_TIP:
      type = "TIP";
    break;
    case MC_TRAN_MERCHRETURN:
      type = "MERCHRETURN";
    break;
    case MC_TRAN_IVRREQ:
      type = "IVRREQ";
    break;
    case MC_TRAN_IVRRESP:
      type = "IVRRESP";
    break;
  };
  return(type);
}

char *M_GetAdminTypeString(int trans_type)
{
  char *type=NULL;

  switch(trans_type) {
    case MC_ADMIN_GUT:
      type="GUT";
    break;
    case MC_ADMIN_GL:
      type="GL";
    break;
    case MC_ADMIN_GFT:
      type="GFT";
    break;
    case MC_ADMIN_QC:
      type="QC";
    break;
    case MC_ADMIN_RS:
      type="RS";
    break;
    case MC_ADMIN_BT:
      type="BT";
    break;
    case MC_ADMIN_CTH:
      type="CTH";
    break;
    case MC_ADMIN_CFH:
      type="CFH";
    break;
    case MC_ADMIN_FORCESETTLE:
      type="FORCESETTLE";
    break;
    case MC_ADMIN_SETBATCHNUM:
      type="SETBATCHNUM";
    break;
    case MC_ADMIN_RENUMBERBATCH:
      type="RENUMBERBATCH";
    break;
    case MC_ADMIN_FIELDEDIT:
      type="FIELDEDIT";
    break;
    case MC_ADMIN_CLOSEBATCH:
      type="CLOSEBATCH";
    break;
  };
  return(type);
}

char *M_GetEngineAdminTypeString(int trans_type)
{
  char *type=NULL;
  switch (trans_type) {
    case MC_TRAN_CHNGPWD:
      type="CHNGPWD";
    break;
    case MC_TRAN_LISTSTATS:
      type="LISTSTATS";
    break;
    case MC_TRAN_LISTUSERS:
      type="LISTUSERS";
    break;
    case MC_TRAN_GETUSERINFO:
      type="GETUSERINFO";
    break;
    case MC_TRAN_ADDUSER:
      type="ADDUSER";
    break;
    case MC_TRAN_EDITUSER:
      type="EDITUSER";
    break;
    case MC_TRAN_DELUSER:
      type="DELUSER";
    break;
    case MC_TRAN_ENABLEUSER:
      type="ENABLEUSER";
    break;
    case MC_TRAN_DISABLEUSER:
      type="DISABLEUSER";
    break;
    case MC_TRAN_IMPORT:
      type="IMPORT";
    break;
    case MC_TRAN_EXPORT:
      type="EXPORT";
    break;
    case MC_TRAN_ERRORLOG:
      type="ERRORLOG";
    break;
    case MC_TRAN_CLEARERRORLOG:
      type="CLEARERRORLOG";
    break;
    case MC_TRAN_GETSUBACCTS:
      type="GETSUBACCTS";
    break;
  };
  return(type);
}

char *M_GetUserArgString(int arg)
{
  char *str=NULL;

  switch(arg) {
    case MC_USER_PROC:
      str="PROC";
    break;
    case MC_USER_USER:
      str="USER";
    break;
    case MC_USER_PWD:
      str="PWD";
    break;
    case MC_USER_INDCODE:
      str="INDCODE";
    break;
    case MC_USER_MERCHID:
      str="MERCHID";
    break;
    case MC_USER_BANKID:
      str="BANKID";
    break;
    case MC_USER_TERMID:
      str="TERMID";
    break;
    case MC_USER_CLIENTNUM:
      str="CLIENTNUM";
    break;
    case MC_USER_STOREID:
      str="STOREID";
    break;
    case MC_USER_AGENTID:
      str="AGENTID";
    break;
    case MC_USER_CHAINID:
      str="CHAINID";
    break;
    case MC_USER_ZIPCODE:
      str="ZIPCODE";
    break;
    case MC_USER_TIMEZONE:
      str="TIMEZONE";
    break;
    case MC_USER_MERCHCAT:
      str="MERCHCAT";
    break;
    case MC_USER_MERNAME:
      str="MERNAME";
    break;
    case MC_USER_MERCHLOC:
      str="MERCHLOC";
    break;
    case MC_USER_STATECODE:
      str="STATECODE";
    break;
    case MC_USER_PHONE:
      str="SERVICEPHONE";
    break;
    case MC_USER_SUB:
      str="SUB";
    break;
    case MC_USER_CARDTYPES:
      str="CARDTYPES";
    break;
    case MC_USER_MODE:
      str="MODE";
    break;
    case MC_USER_VNUMBER:
      str="VNUMBER";
    break;
    case MC_USER_ROUTINGID:
      str="ROUTINGID";
    break;
    case MC_USER_PPROPERTY:
      str="PPROPERTY";
    break;
    case MC_USER_PID:
      str="PID";
    break;
    case MC_USER_PIDPWD:
      str="PIDPWD";
    break;
    case MC_USER_SMID:
      str="SMID";
    break;
    case MC_USER_SMIDPWD:
      str="SMIDPWD";
    break;
    case MC_USER_USDDIV:
      str="USDDIV";
    break;
    case MC_USER_AUDDIV:
      str="AUDDIV";
    break;
    case MC_USER_DKKDIV:
      str="DKKDIV";
    break;
    case MC_USER_GBPDIV:
      str="GBPDIV";
    break;
    case MC_USER_HKDDIV:
      str="HKDDIV";
    break;
    case MC_USER_JPYDIV:
      str="JPYDIV";
    break;
    case MC_USER_NZDDIV:
      str="NZDDIV";
    break;
    case MC_USER_NOKDIV:
      str="NOKDIV";
    break;
    case MC_USER_SGDDIV:
      str="SGDDIV";
    break;
    case MC_USER_ZARDIV:
      str="ZARDIV";
    break;
    case MC_USER_SEKDIV:
      str="SEKDIV";
    break;
    case MC_USER_CHFDIV:
      str="CHFDIV";
    break;
    case MC_USER_CADDIV:
      str="CADDIV";
    break;
    case MC_USER_DIVNUM:
      str="DIVNUM";
    break;

  };
  return(str);
}


char *M_GetExchargesArgString(int excharges_type)
{
  char *str=NULL;

  switch(excharges_type) {
    case MC_EXCHARGES_REST:
      str="REST";
    break;
    case MC_EXCHARGES_GIFT:
      str="GIFT";
    break;
    case MC_EXCHARGES_MINI:
      str="MINI";
    break;
    case MC_EXCHARGES_TELE:
      str="TELE";
    break;
    case MC_EXCHARGES_OTHER:
      str="OTHER";
    break;
    case MC_EXCHARGES_LAUND:
      str="LAUND";
    break;
    case MC_EXCHARGES_NONE:
      str="NONE";
    break;
    case MC_EXCHARGES_GAS:
      str="GAS";
    break;
    case MC_EXCHARGES_MILE:
      str="MILE";
    break;
    case MC_EXCHARGES_LATE:
      str="LATE";
    break;
    case MC_EXCHARGES_1WAY:
      str="1WAY";
    break;
    case MC_EXCHARGES_VIOL:
      str="VIOL";
    break;
  }

  return (str);
}

char *M_GetPriorityString(int priority)
{
  char *str=NULL;

  switch(priority) {
    case MC_PRIO_HIGH:
      str="HIGH";
    break;
    case MC_PRIO_NORMAL:
      str="NORMAL";
    break;
    case MC_PRIO_LOW:
      str="LOW";
    break;
  }

  return (str);
}

char *M_GetCardTypesString(int types)
{
  char *ret=NULL;
  ret=(char *)malloc(100);
  ret[0]=0;

  if (types & ~MC_CARD_ALL) {
    strcat(ret, "ALL");
    return(ret);
  }

  if (types & ~MC_CARD_VISA) {
    strcat(ret, "+VISA");
  }
  if (types & ~MC_CARD_MC) {
    strcat(ret, "+MC");
  }
  if (types & ~MC_CARD_AMEX) {
    strcat(ret, "+AMEX");
  }
  if (types & ~MC_CARD_DISC) {
    strcat(ret, "+DISC");
  }
  if (types & ~MC_CARD_DC) {
    strcat(ret, "+DC");
  }
  if (types & ~MC_CARD_JCB) {
    strcat(ret, "+JCB");
  }
  if (types & ~MC_CARD_CB) {
    strcat(ret, "+CB");
  }
  if (types & ~MC_CARD_GIFT) {
    strcat(ret, "+GIFT");
  }
  if (types & ~MC_CARD_OTHER) {
    strcat(ret, "+OTHER");
  }
  return(ret);
}

char *M_GetModeString(int types)
{
  char *ret=NULL;
  ret=(char *)malloc(100);
  ret[0]=0;

  if (types & ~MC_MODE_BOTH) {
    strcat(ret, "BOTH");
    return(ret);
  }

  if (types & ~MC_MODE_AUTH) {
    strcat(ret, "+AUTH");
  }
  if (types & ~MC_MODE_SETTLE) {
    strcat(ret, "+SETTLE");
  }

  return(ret);
}

char *
M_EscapeTransaction(const char *trans)
{
	char *replace, *ret;
	int   i, j;

	if (trans == NULL)
		return (NULL);
	if (strlen(trans) == 0)
		return (strdup(""));

	ret = strdup(trans);
	for (i = 0; ret[i] != '\0'; i++) {
		replace = NULL;
		if (ret[i] == '\r')
			replace = "\\r";
		else if (ret[i] == '\n')
			replace = "\\n";
		else if (ret[i] == ',')
			replace = "\\c";
		else if (ret[i] == '\'')
			replace = "\\s";
		else if (ret[i] == '\"')
			replace = "\\d";
		else if (ret[i] == '\\')
			replace = "\\b";
		if (replace == NULL)
			continue;

		ret = realloc(ret, strlen(ret) + 2);

		for (j = strlen(ret) + 1; j > i; j--)
			ret[j + 1] = ret[j];

		memcpy(ret + i, replace, strlen(replace));
		i++;
	}

	return (ret);
}

char *
M_UnscapeTransaction(const char *trans)
{
	char replace, *ret;
	int  i, j;

	if (trans == NULL)
		return (NULL);
	if (strlen(trans) == 0)
		return (strdup(""));

	ret = strdup(trans);

	for (i = 0; ret[i] != '\0'; i++) {
		if (ret[i] != '\\')
			continue;

		replace = '\0';

		if (ret[i + 1] == '\\')
			replace = '\\';
		else if (ret[i + 1] == 'r')
			replace = '\r';
		else if (ret[i + 1] == 'n')
			replace = '\n';
		else if (ret[i + 1] == 'c')
			replace = ',';
		else if (ret[i + 1] == 's')
			replace = '\'';
		else if (ret[i + 1] == 'd')
			replace = '\"';
		else if (ret[i + 1] == 'b')
			replace = '\\';

		if (replace == '\0')
			continue;

		ret[i] = replace;
		for (j = i + 1; ; j++) {
			ret[j] = ret[j + 1];
			if (ret[j] == '\0')
				break;
		}
	}

	return (ret);
}
