/* Monetra v4.x C API
   (c) 2004 by Main Street Softworks, Inc.

   This API is being released to the public domain to be modified and used in any manor the holder of this code sees fit.
   For any questions please contact  support@mainstreetsoftworks.com
*/

#ifndef __MONETRA_H__
#define __MONETRA_H__

#ifdef HAVE_CONFIG_H
#ifdef WIN32
#include "w32config.h"
#else /* !WIN32 */
#include "config.h"
#endif /* !WIN32 */
#endif /* HAVE_CONFIG_H */

#ifdef WIN32
#ifdef M_INTERNAL
#define M_EXPORT __declspec(dllexport)
#else /* !M_INTERNAL */
#define M_EXPORT __declspec(dllimport)
#endif /* !M_INTERNAL */
#else /* !WIN32 */
#define M_EXPORT
#endif /* !WIN32 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "libmonetra_compat.h"

#define M_Safe(a) (a==NULL?"":a)

#ifdef WIN32
typedef unsigned __int64 M_uint64;
typedef signed __int64 M_int64;
#else /* !WIN32 */
#ifdef NO_LONG_LONG
/* This is wrong, but what else can we do? */
typedef unsigned long M_uint64;
typedef long M_int64;

#else /* !NO_LONG_LONG */

typedef unsigned long long M_uint64;
typedef long long M_int64;

#endif /* !NO_LONG_LONG */
#endif /* !WIN32 */


/* Key definitions for Transaction Parameters */
#define MC_TRANTYPE		1
#define MC_USERNAME		2
#define MC_PASSWORD		3
#define MC_ACCOUNT		4
#define MC_TRACKDATA		5
#define MC_EXPDATE		6
#define MC_STREET		7
#define MC_ZIP			8
#define MC_CV			9
#define MC_COMMENTS		10
#define MC_CLERKID		11
#define MC_STATIONID		12
#define MC_APPRCODE		13
#define MC_AMOUNT		14
#define MC_PTRANNUM		15
#define MC_TTID			16
#define MC_USER			17
#define MC_PWD			18
#define MC_ACCT			19
#define MC_BDATE		20
#define MC_EDATE		21
#define MC_BATCH		22
#define MC_FILE			23
#define MC_ADMIN		24
#define MC_AUDITTYPE		25
#define MC_CUSTOM		26
/* restaurant, lodging, auto-rental */
#define MC_EXAMOUNT     	27
#define MC_EXCHARGES    	28
#define MC_RATE         	29
#define MC_RENTERNAME   	30
#define MC_RETURNCITY   	31
#define MC_RETURNSTATE  	32
#define MC_RETURNLOCATION       33
#define MC_PRIORITY		34
#define MC_INQUIRY		35

#define MC_CARDTYPES		36
#define MC_SUB			37
#define MC_MARKER		38
#define MC_DEVICETYPE		39
#define MC_ERRORCODE		40
#define MC_NEWBATCH		41
#define MC_CURR			42
#define MC_DESCMERCH		43
#define MC_DESCLOC		44
#define MC_ORIGTYPE		45
#define MC_PIN			46
#define MC_VOIDORIGTYPE		47
#define MC_TIMESTAMP            48



/* Priorities */
#define MC_PRIO_HIGH	1
#define MC_PRIO_NORMAL	2
#define MC_PRIO_LOW	3


/* Excharges for lodging and auto-rental*/
#define MC_EXCHARGES_REST         1
#define MC_EXCHARGES_GIFT         2
#define MC_EXCHARGES_MINI         3
#define MC_EXCHARGES_TELE         4
#define MC_EXCHARGES_OTHER        5
#define MC_EXCHARGES_LAUND        6
#define MC_EXCHARGES_NONE         7

#define MC_EXCHARGES_GAS          8
#define MC_EXCHARGES_MILE         9
#define MC_EXCHARGES_LATE         10
#define MC_EXCHARGES_1WAY         11
#define MC_EXCHARGES_VIOL         12


/* Args for adding a user */
#define MC_USER_PROC		2000
#define MC_USER_USER		2001
#define MC_USER_PWD		2002
#define MC_USER_INDCODE		2003
#define MC_USER_MERCHID		2004
#define MC_USER_BANKID		2005
#define MC_USER_TERMID		2006
#define MC_USER_CLIENTNUM	2007
#define MC_USER_STOREID		2008
#define MC_USER_AGENTID		2009
#define MC_USER_CHAINID		2010
#define MC_USER_ZIPCODE		2011
#define MC_USER_TIMEZONE	2012
#define MC_USER_MERCHCAT	2013
#define MC_USER_MERNAME		2014
#define MC_USER_MERCHLOC	2015
#define MC_USER_STATECODE	2016
#define MC_USER_PHONE		2017
#define MC_USER_SUB		2018
#define MC_USER_CARDTYPES	2019
#define MC_USER_MODE		2020
#define MC_USER_VNUMBER		2021
#define MC_USER_ROUTINGID	2022
#define MC_USER_PPROPERTY	2023
#define MC_USER_PID		2024
#define MC_USER_PIDPWD		2025
#define MC_USER_SMID		2026
#define MC_USER_SMIDPWD		2027
#define MC_USER_USDDIV		2028
#define MC_USER_AUDDIV		2029
#define MC_USER_DKKDIV		2030
#define MC_USER_GBPDIV		2031
#define MC_USER_HKDDIV		2032
#define MC_USER_JPYDIV		2033
#define MC_USER_NZDDIV		2034
#define MC_USER_NOKDIV		2035
#define MC_USER_SGDDIV		2036
#define MC_USER_ZARDIV		2037
#define MC_USER_SEKDIV		2038
#define MC_USER_CHFDIV		2039
#define MC_USER_CADDIV		2040
#define MC_USER_DIVNUM          2041


/* Card Types */
#define MC_CARD_VISA	2
#define MC_CARD_MC	4
#define MC_CARD_AMEX	8
#define MC_CARD_DISC	16
#define MC_CARD_JCB	32
#define MC_CARD_CB	64
#define MC_CARD_DC	128
#define MC_CARD_GIFT	256
#define MC_CARD_OTHER	512
#define MC_CARD_ALL 	(MC_CARD_VISA|MC_CARD_MC|MC_CARD_AMEX|MC_CARD_DISC|MC_CARD_JCB|MC_CARD_CB|MC_CARD_DC|MC_CARD_GIFT|MC_CARD_OTHER)

/* Modes */
#define MC_MODE_AUTH	2
#define MC_MODE_SETTLE	4
#define MC_MODE_BOTH	(MC_MODE_AUTH|MC_MODE_SETTLE)
#define MC_MODE_ALL	MC_MODE_BOTH

/* Value definitions for Transaction Types */
#define MC_TRAN_SALE		1
#define MC_TRAN_REDEMPTION	MC_TRAN_SALE
#define MC_TRAN_PREAUTH		2
#define MC_TRAN_VOID		3
#define MC_TRAN_PREAUTHCOMPLETE	4
#define MC_TRAN_FORCE		5
#define MC_TRAN_OVERRIDE	6
#define MC_TRAN_RETURN		7
#define MC_TRAN_RELOAD		MC_TRAN_RETURN
#define MC_TRAN_CREDIT		MC_TRAN_RETURN
#define MC_TRAN_SETTLE		8
#define MC_TRAN_INCREMENTAL    	9
#define MC_TRAN_REVERSAL        10
#define MC_TRAN_ACTIVATE	11
#define MC_TRAN_BALANCEINQ	12
#define MC_TRAN_CASHOUT		13
#define MC_TRAN_TOREVERSAL	14
#define MC_TRAN_SETTLERFR	15
#define MC_TRAN_ISSUE		16
#define MC_TRAN_TIP		17
#define MC_TRAN_MERCHRETURN	18
#define MC_TRAN_IVRREQ		19
#define MC_TRAN_IVRRESP	 	20
#define MC_TRAN_ADMIN		50
#define MC_TRAN_PING		100
#define MC_TRAN_CHKPWD		200


/* Engine Admin Transaction Types */
#define MC_TRAN_CHNGPWD		1001
#define MC_TRAN_LISTSTATS	1002
#define MC_TRAN_LISTUSERS	1003
#define MC_TRAN_GETUSERINFO	1004
#define MC_TRAN_ADDUSER		1005
#define MC_TRAN_EDITUSER	1006
#define MC_TRAN_DELUSER		1007
#define MC_TRAN_ENABLEUSER	1008
#define MC_TRAN_DISABLEUSER	1009
#define MC_TRAN_IMPORT		1010
#define MC_TRAN_EXPORT		1011
#define MC_TRAN_ERRORLOG	1012
#define MC_TRAN_CLEARERRORLOG	1013
#define MC_TRAN_GETSUBACCTS	1014


/* Value definitions for Admin Types */
#define MC_ADMIN_GUT		1
#define MC_ADMIN_GL		2
#define MC_ADMIN_GFT		3
#define MC_ADMIN_BT		4
#define MC_ADMIN_UB		MC_ADMIN_BT
#define MC_ADMIN_QC		5
#define MC_ADMIN_RS		6
#define MC_ADMIN_CTH		7
#define MC_ADMIN_CFH		8
#define MC_ADMIN_FORCESETTLE	9
#define MC_ADMIN_SETBATCHNUM	10
#define MC_ADMIN_RENUMBERBATCH	11
#define MC_ADMIN_FIELDEDIT	12
#define MC_ADMIN_CLOSEBATCH	13

/* Transaction States */
#define M_UNUSED 0
#define M_NEW 100
#define M_PENDING 1
#define M_DONE 2

/* Transaction Results */
#define M_ERROR -1
#define M_FAIL 0
#define M_SUCCESS 1
#define M_AUTH 2
#define M_DENY 3
#define M_CALL 4
#define M_DUPL 5
#define M_PKUP 6
#define M_RETRY 7
#define M_SETUP 8
#define M_TIMEOUT 9

// AVS/CVV2 response codes
#define M_GOOD 1
#define M_BAD 0
#define M_STREET 2
#define M_ZIP 3
#define M_UNKNOWN -1

/* SSL retries */
#ifndef M_SSL_RETRIES
#define	M_SSL_RETRIES	5
#endif

typedef void * M_CONN;

/* BASE ROUTINES */
M_EXPORT int M_InitEngine(char *location);
M_EXPORT void M_DestroyEngine();
M_EXPORT void M_InitConn(M_CONN *myconn);
M_EXPORT int M_SetBlocking(M_CONN *myconn, int tf);
M_EXPORT int M_SetTimeout(M_CONN *myconn, long timeout);
M_EXPORT int M_SetDropFile(M_CONN *myconn, char *df_location);
M_EXPORT int M_SetIP(M_CONN *myconn, char *host, unsigned short port);
M_EXPORT int M_SetSSL(M_CONN *myconn, char *host, unsigned short port);
M_EXPORT int M_SetSSL_Files(const char *sslkeyfile, const char *sslcertfile);
M_EXPORT void M_VerifyConnection(M_CONN *myconn, int tf);
M_EXPORT void M_VerifySSLCert(M_CONN *myconn, int tf);
M_EXPORT int M_Connect(M_CONN *myconn);
M_EXPORT void M_MaxConnTimeout(M_CONN *myconn, int maxtime);
M_EXPORT char *M_ConnectionError(M_CONN *myconn);
M_EXPORT void M_DestroyConn(M_CONN *myconn);
M_EXPORT int M_Monitor(M_CONN *myconn);
M_EXPORT int M_TransactionsSent(M_CONN *myconn);
M_EXPORT long M_Ping(M_CONN *myconn);
#define M_DeleteResponse(a, b) M_DeleteTrans(a, b)
M_EXPORT void M_DeleteTrans(M_CONN *myconn, long identifier);

M_EXPORT long M_TransNew(M_CONN *myconn);
M_EXPORT int M_TransParam(M_CONN *myconn, long identifier, int key, ...);
M_EXPORT int M_TransSend(M_CONN *myconn, long identifier);
M_EXPORT char *M_ResponseParam(M_CONN *myconn, long identifier, char *key);
M_EXPORT char **M_ResponseKeys(M_CONN *myconn, long identifier, int *num_keys);
M_EXPORT int M_FreeResponseKeys(char **keys, int num_keys);

/* Transaction Routines */
M_EXPORT long M_Sale(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                               char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum);
M_EXPORT long M_PreAuth(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum);
M_EXPORT long M_Void(M_CONN *myconn, char *username, char *password, M_int64 ttid, long ptrannum);
M_EXPORT long M_PreAuthCompletion(M_CONN *myconn, char *username, char *password, double finalamount, M_int64 ttid, long ptrannum);
M_EXPORT long M_Force(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                char *authcode, char *comments, char *clerkid, char *stationid, long ptrannum);
M_EXPORT long M_Return(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *comments, char *clerkid, char *stationid, long ptrannum);
M_EXPORT long M_Override(M_CONN *myconn, char *username, char *password, char *trackdata, char *account, char *expdate, double amount,
                                     char *street, char *zip, char *cv, char *comments, char *clerkid, char *stationid, long ptrannum);
M_EXPORT long M_Settle(M_CONN *myconn, char *username, char *password, char *batch);

/* Response Checking Routines */
M_EXPORT int M_ReturnStatus(M_CONN *myconn, long identifier);
M_EXPORT int M_ReturnCode(M_CONN *myconn, long identifier);
M_EXPORT long M_TransactionItem(M_CONN *myconn, long identifier);
M_EXPORT long M_TransactionBatch(M_CONN *myconn, long identifier);
M_EXPORT M_int64 M_TransactionID(M_CONN *myconn, long identifier);
M_EXPORT char *M_TransactionAuth(M_CONN *myconn, long identifier);
M_EXPORT char *M_TransactionText(M_CONN *myconn, long identifier);
M_EXPORT int M_TransactionAVS(M_CONN *myconn, long identifier);
M_EXPORT int M_TransactionCV(M_CONN *myconn, long identifier);
M_EXPORT long M_TransInQueue(M_CONN *myconn);
M_EXPORT int M_CheckStatus(M_CONN *myconn, long trans);
M_EXPORT long M_CompleteAuthorizations(M_CONN *myconn, long **listings);
M_EXPORT char *M_EscapeTransaction(const char *trans);
M_EXPORT char *M_UnscapeTransaction(const char *trans);


/* User-level administrative requests */

M_EXPORT long M_Gut(M_CONN *myconn, char *username, char *password, int type, char *acct, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate);
M_EXPORT long M_Gl(M_CONN *myconn, char *username, char *password, int type, char *acct, char *batch, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate);
M_EXPORT long M_Gft(M_CONN *myconn, char *username, char *password, int type, char *acct, char *clerkid, char *stationid, char *comments,
                              double ptrannum, char *bdate, char *edate);
//long M_Ub(M_CONN *myconn, char *username, char *password);
M_EXPORT long M_Rs(M_CONN *myconn, char *username, char *password, char *stationid);
M_EXPORT long M_Qc(M_CONN *myconn, char *username, char *password, char *clerkid, char *stationid, char *comments, double ptrannum);
M_EXPORT long M_Chkpwd(M_CONN *myconn, char *username, char *password);
M_EXPORT long M_Bt(M_CONN *myconn, char *username, char *password);
#define M_Ub(a,b,c) M_Bt(a,b,c)

/* Engine-Admin requests */

M_EXPORT long M_Chngpwd(M_CONN *myconn, char *adminpwd, char *newpassword);
M_EXPORT long M_ListUsers(M_CONN *myconn, char *adminpwd);
M_EXPORT long M_EnableUser(M_CONN *myconn, char *adminpwd, char *user);
M_EXPORT long M_DisableUser(M_CONN *myconn, char *adminpwd, char *user);
M_EXPORT long M_GetUserInfo(M_CONN *myconn, char *adminpwd, char *user);
M_EXPORT long M_DelUser(M_CONN *myconn, char *adminpwd, char *user);
M_EXPORT long M_ListStats(M_CONN *myconn, char *adminpwd);
M_EXPORT long M_Export(M_CONN *myconn, char *adminpwd, char *filename);
M_EXPORT long M_Import(M_CONN *myconn, char *adminpwd, char *filename);

/* Reading special administrative responses */

M_EXPORT char *M_GetUserParam(M_CONN *myconn, long identifier, int key);

/* Comma Delimited Routines */
M_EXPORT int M_IsCommaDelimited(M_CONN *myconn, long identifier);
M_EXPORT int M_ParseCommaDelimited(M_CONN *myconn, long identifier);
M_EXPORT char *M_GetCommaDelimited(M_CONN *myconn, long identifier);
M_EXPORT char *M_GetCell(M_CONN *myconn, long identifier, char *column, long row);
M_EXPORT char *M_GetCellByNum(M_CONN *myconn, long identifier, int column, long row);
M_EXPORT int M_NumColumns(M_CONN *myconn, long identifier);
M_EXPORT long M_NumRows(M_CONN *myconn, long identifier);
M_EXPORT char *M_GetHeader(M_CONN *myconn, long identifier, int column_num);


/* ----------------EMULATION SEGMENT---------------------------
 * Strictly for emulating old "user" functions
 */

#define M_SALE MC_TRAN_SALE
#define M_PREAUTH MC_TRAN_PREAUTH
#define M_FORCE MC_TRAN_FORCE
#define M_OVERRIDE MC_TRAN_OVERRIDE
#define M_RETURN MC_TRAN_RETURN
#define M_VOID MC_TRAN_VOID
#define M_SETTLE MC_TRAN_SETTLE


// USER SETUP INFORMATION
#define M_PROC MC_USER_PROC
#define M_USER MC_USER_USER
#define M_PWD MC_USER_PWD
#define M_INDCODE MC_USER_INDCODE
#define M_MERCHID MC_USER_MERCHID
#define M_BANKID MC_USER_BANKID
#define M_TERMID MC_USER_TERMID
#define M_CLIENTNUM MC_USER_CLIENTNUM
#define M_STOREID MC_USER_STOREID
#define M_AGENTID MC_USER_AGENTID
#define M_CHAINID MC_USER_CHAINID
#define M_ZIPCODE MC_USER_ZIPCODE
#define M_TIMEZONE MC_USER_TIMEZONE
#define M_MERCHCAT MC_USER_MERCHCAT
#define M_MERNAME MC_USER_MERNAME
#define M_MERCHLOC MC_USER_MERCHLOC
#define M_STATECODE MC_USER_STATECODE
#define M_SERVICEPHONE MC_USER_PHONE

typedef void * M_UserSetup;

M_EXPORT long M_AddUser(M_CONN *myconn, char *adminpwd, M_UserSetup *setup);
M_EXPORT long M_EditUser(M_CONN *myconn, char *adminpwd, M_UserSetup *setup);
M_EXPORT void M_InitUserSetup(M_UserSetup *setup);
M_EXPORT void M_DeleteUserSetup(M_UserSetup *setup);
M_EXPORT char *M_GetUserArg(M_UserSetup *usersetup, int argtype);
M_EXPORT int M_AddUserArg(M_UserSetup *setup, int argtype, char *argval);


M_EXPORT int M_uwait(unsigned long length);

/* TEXT RESPONSE CONVERSIONS */

M_EXPORT char *M_TEXT_Code(int code);
M_EXPORT char *M_TEXT_AVS(int code);
M_EXPORT char *M_TEXT_CV(int code);

typedef void *(* M_Register_Mutex)(void);
typedef int (* M_Mutex_Lock)(void *);
typedef int (* M_Mutex_Unlock)(void *);
typedef int (* M_Unregister_Mutex)(void *);

M_EXPORT int M_Register_mutexinit(M_CONN *myconn, M_Register_Mutex reg);
M_EXPORT int M_Register_mutexdestroy(M_CONN *myconn, M_Unregister_Mutex reg);
M_EXPORT int M_Register_mutexlock(M_CONN *myconn, M_Mutex_Lock reg);
M_EXPORT int M_Register_mutexunlock(M_CONN *myconn, M_Mutex_Unlock reg);
M_EXPORT int M_EnableThreadSafety(M_CONN *myconn);
#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
