#include <stdio.h>
#include <stdlib.h>
#include "monetra.h"

int main()
{
  char *host="testbox.mcve.com";
  unsigned short port=8333;
  MCVE_CONN conn;
  long identifier; 
  printf("WIN32 LIBMONETRA TEST PROGRAM\r\n");
  MCVE_InitEngine(NULL);
  MCVE_InitConn(&conn);
  MCVE_SetIP(&conn, host, port);
  MCVE_SetBlocking(&conn, 1);
  printf("Connection to %s:%d\r\n", host, (int)port);
  if (!MCVE_Connect(&conn)) {
    printf("Connection Failed: %s\r\n", MCVE_ConnectionError(&conn));
    exit(1);
  }
  printf("Connected\r\n");
  identifier=MCVE_TransNew(&conn);
  MCVE_TransParam(&conn, identifier, MC_USERNAME, "vitale");
  MCVE_TransParam(&conn, identifier, MC_PASSWORD, "test");
  MCVE_TransParam(&conn, identifier, MC_TRANTYPE, MC_TRAN_SALE);
  MCVE_TransParam(&conn, identifier, MC_ACCOUNT, "4012888888881");
  MCVE_TransParam(&conn, identifier, MC_EXPDATE, "0512");
  MCVE_TransParam(&conn, identifier, MC_AMOUNT, 12.00);
  printf("Sending Transaction\r\n");
  if (!MCVE_TransSend(&conn, identifier)) {
    printf("Could not send trans\r\n");
    MCVE_DestroyConn(&conn);
  }
  printf("Transaction response received\r\n");
  if (MCVE_ReturnStatus(&conn, identifier) == MCVE_SUCCESS) {
    printf("Transaction Authorized: %s -- %s\r\n", MCVE_TEXT_Code(MCVE_ReturnCode(&conn, identifier)),
		   MCVE_TransactionText(&conn, identifier));
  } else {
    printf("Transaction Denied: %s -- %s\r\n", MCVE_TEXT_Code(MCVE_ReturnCode(&conn, identifier)),
		   MCVE_TransactionText(&conn, identifier));
  }
  MCVE_DestroyConn(&conn);
  MCVE_DestroyEngine();
  return(0);
}
