/* PEAK Library
 *
 * Copyright (c) 2003
 *      Stephane Thiell <mbuna@bugged.org>. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */
#define RCSID "$Id: init.c,v 1.1.1.1 2003/12/30 02:29:17 mbuna Exp $"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "init_private.h"
#include <pthread.h>

/* Globals
 */
int _peak_is_threaded;


static int __peak_initialized = 0;
static pthread_key_t __task_key, __task_runloop_key;


static void
__peak_init()
  {
  __peak_initialized = 1;
  _peak_is_threaded = 0;
  
  if (pthread_key_create(&__task_key, NULL) ||
      pthread_key_create(&__task_runloop_key, NULL))
    PEAK_HALT;
  }

__private_extern__ void
_peak_init_thread_task(peak_task task)
  {
  pthread_setspecific(__task_key, (void *)task);
  }

__private_extern__ void
_peak_init_thread_runloop(peak_task_runloop rl)
  {
  pthread_setspecific(__task_runloop_key, (void *)rl);
  }

peak_task
peak_task_self()
  {
  void *obj;
  
  if (__peak_initialized && (obj = pthread_getspecific(__task_key)) != NULL)
    return (peak_task)obj;    /* Normal prediction */
  else if (__peak_initialized == 0)
    __peak_init();            /* Once */
  return _peak_task_create(); /* Once per task */
  }

__private_extern__ peak_task_runloop
_peak_task_runloop_self()
  {
  return (peak_task_runloop)pthread_getspecific(__task_runloop_key);
  }
