/* $Id: ifdhandler.h,v 1.2 2003/06/19 22:40:53 rees Exp $ */

/*
copyright 2001
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/

#ifndef _IFDHANDLER_H_
#define _IFDHANDLER_H_

/*
 * pcsc cruft
 */

#define MAX_ATR_SIZE 33
#define IFD_POWER_UP 500
#define IFD_POWER_DOWN 501
#define IFD_RESET 502
#define IFD_ERROR_NOT_SUPPORTED 606
#define IFD_ERROR_POWER_ACTION 608
#define IFD_COMMUNICATION_ERROR 612
#define IFD_NOT_SUPPORTED 614
#define IFD_ICC_PRESENT 615
#define IFD_ICC_NOT_PRESENT 616
#define TAG_IFD_ATR 0x303

/* Extra tags for things they forgot to put in the ifd interface */
#define SCTAG_IFD_ATRLEN 0x6601
#define SCTAG_IFD_CARDPRESENT 0x301
#define SCTAG_OPEN_FLAGS  0x800
#define SCTAG_RESET_FLAGS 0x801

#define IFDH_VERSION_1_0	1
#define IFDH_VERSION_2_0	2

typedef struct _SCARD_IO_HEADER {
    unsigned long Protocol, Length;
} SCARD_IO_HEADER;

typedef struct {
    unsigned long 	channelID;
    unsigned long	lun;
    char 		*driverPath;
    unsigned int	driverLoaded;
    int			version;
    void *open;
    void *close;
    void *data;
    void *power;
    void *getcapa;
    void *setcapa;
    void *cardpresent;
} readerInfo;

/* IFD interface version 1 */
unsigned long IO_Create_Channel(unsigned long ChannelId);
unsigned long IO_Close_Channel();
unsigned long IFD_Get_Capabilities(unsigned long Tag, unsigned char Value[]);
unsigned long IFD_Set_Capabilities(unsigned long Tag, unsigned char Value[]);
unsigned long IFD_Set_Protocol_Parameters(unsigned long ProtocolType, unsigned char SelectionFlags, unsigned char PTS1, unsigned char PTS2, unsigned char PTS3);
unsigned long IFD_Power_ICC(unsigned long a);
unsigned long IFD_Swallow_ICC();
unsigned long IFD_Eject_ICC();
unsigned long IFD_Confiscate_ICC();
unsigned long IFD_Transmit_to_ICC(SCARD_IO_HEADER SendPci,
		    unsigned char ibuf[], unsigned long ilen,
		    unsigned char obuf[], unsigned long *olen,
		    SCARD_IO_HEADER *RecvPci);
unsigned long IFD_Is_ICC_Present();

/* IFD interface version 2 */
unsigned long IFDHCreateChannel(unsigned long Lun, unsigned long Channel);
unsigned long IFDHCloseChannel(unsigned long Lun);
unsigned long IFDHGetCapabilities (unsigned long Lun, unsigned long Tag,
		unsigned long *length, unsigned char *value);
unsigned long IFDHSetCapabilities (unsigned long Lun, unsigned long Tag,
		unsigned long Length, unsigned char *value);
unsigned long IFDHSetProtocolParameters (unsigned long Lun,
		unsigned long Protocol, unsigned char Flags,
		unsigned char PTS1, unsigned char PTS2, unsigned char PTS3);
unsigned long IFDHPowerICC (unsigned long Lun, unsigned long Action,
		unsigned char *Atr, unsigned long *AtrLength);
unsigned long IFDHTransmitToICC (unsigned long Lun, SCARD_IO_HEADER SendPci,
		unsigned char *TxBuffer, unsigned long TxLength,
		unsigned char *RxBuffer, unsigned long RxLength,
		SCARD_IO_HEADER *RecvPci);
unsigned long IFDHControl (unsigned long Lun, unsigned char* TxBuffer,
		unsigned long TxLength, unsigned char *RxBuffer,
		unsigned long *RxLength);
unsigned long IFDHICCPresence(unsigned long Lun);

#endif /* _IFDHANDLER_H_ */
