#ifndef foointernalhfoo
#define foointernalhfoo

/* $Id: internal.h,v 1.2 2002/05/02 16:16:30 poettering Exp $
 *
 * This file is part of libshbuf. 
 *
 * asd is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * asd is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libshbuf; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/msg.h>
#include <pthread.h>

typedef struct {
    unsigned int id;

    // The following id may not be endian safe. But who cares? The ID
    // is not exchanged between machines, so endianess is irrelevant
    
#define SHBUF_CONTROL_ID ((unsigned int)'S' | (unsigned int)'H' << 8 | (unsigned int)'B' << 16 | (unsigned int)'F' << 24)

    int version;
#define SHBUF_CONTROL_VERSION 2
    
    shbuf_status status;
    unsigned long size;
    
    key_t buffer_shm_key;
    key_t sem_key;
    key_t msg_key;

    int provider_attached;
    int client_attached;

    int provider_notify;
    int client_notify;
} shbuf_control;

struct _shbuf {
    key_t control_shm_key;
    
    int control_shmid;
    int buffer_shmid;
    int semid;
    int msgid;
    
    shbuf_control *control;
    unsigned char* buffer;

    int fifo_fd_read;
    int fifo_fd_write;

    int is_dead;
    int is_provider;

    pthread_t thread;
};

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
/* union semun is defined by including <sys/sem.h> */
#else
/* according to X/OPEN we have to define it ourselves */
union semun {
    int val;                  /* value for SETVAL */
    struct semid_ds *buf;     /* buffer for IPC_STAT, IPC_SET */
    unsigned short *array;    /* array for GETALL, SETALL */
    /* Linux specific part: */
    struct seminfo *__buf;    /* buffer for IPC_INFO */
};
#endif

#endif
