#ifndef fooshbuferrhfoo
#define fooshbuferrhfoo

/* $Id: shbuferr.h,v 1.3 2002/05/02 16:16:30 poettering Exp $
 *
 * This file is part of libshbuf. 
 *
 * asd is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * asd is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libshbuf; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 */

/**
 * Error number specification
 */
typedef enum { SHBUF_NOERROR,                   /**< No error occured */
               SHBUF_BUSY,                      /**< The shared buffer is already opened by another client */
               SHBUF_NOTINNOTIFYMODE,           /**< The shbuf object is not in notify mode */  
               SHBUF_SYSTEM_ERROR_BASE = 100,   /**< Errors with a greater value than this use the libc errno */
               SHBUF_COULDNOTCREATEMSGQ,
               SHBUF_COULDNOTMAPBUFFERSHM,
               SHBUF_COULDNOTCREATEBUFFERSHM,
               SHBUF_COULDNOTRESETSEM,
               SHBUF_COULDNOTCREATESEM,
               SHBUF_COULDNOTMAPCONTROLSHM,
               SHBUF_COULDNOTCREATECONTROLSHM,
               SHBUF_COULDNOTOPENMSGQ,
               SHBUF_COULDNOTOPENCONTROLSHM,
               SHBUF_COULDNOTOPENSEM,
               SHBUF_COULDNOTOPENBUFFERSHM,
               SHBUF_MSGSNDFAILED,
               SHBUF_SELECTFAILED,
               SHBUF_READFAILED,
               SHBUF_ACCESSMODEFAILED,
               SHBUF_COULDNOTCREATEPIPE,
               SHBUF_COULDNOTCREATETHREAD,
               SHBUF_LOCKFAILED,
               SHBUF_UNLOCKFAILED,
               SHBUF_INCOMPATIBLEBUFFER,
} shbuf_error;

/**
 * Sets the libshbuf specific error number. Mainly for internal
 * purposes, but useful for signal handlers too. The libshbuf error
 * number is thread specific.
 *
 * @param e Error number to be set
 */
void shbuf_set_errno(shbuf_error e);

/**
 * Returns the current libshbuf specific error number.
 *
 * @return The current error number
 */
shbuf_error shbuf_get_errno(void);

/**
 * Converts a pair of libshbuf and libc error numbers to a human
 * readable string. The string is thread specific and freed on thread
 * end. Following calls of this function may change the buffer
 * returned.
 *
 * @param e libshbuf specific error number
 * @param en libc specific error number
 * @return The error numbers in a textual representation
 */
char *shbuf_strerror(shbuf_error e, int en);

/**
 * Calls <code>shbuf_strerror()</code> with the current error numbers.
 *
 * @return The current error in a textual representation
 */
char *shbuf_strerror2(void);

/**
 * Emulates the libc <code>perror()</code> function but adds support
 * for libshbuf specific errors.
 *
 * @param p String to be printed adjacent to the current error string
 */
void shbuf_perror(char *p);

#endif
