/* snap_accessors.c: simple accessor functions for libspectrum_snap
   Copyright (c) 2003 Philip Kendall

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* NB: this file is autogenerated from snap_accessors.txt by accessor.pl */

#include "internals.h"

struct libspectrum_snap {

  /* Which machine are we using here? */

  libspectrum_machine machine;

  /* Registers and the like */

  libspectrum_byte a , f ; libspectrum_word bc , de , hl ;
  libspectrum_byte a_, f_; libspectrum_word bc_, de_, hl_;

  libspectrum_word ix, iy; libspectrum_byte i, r;
  libspectrum_word sp, pc;

  libspectrum_byte iff1, iff2, im;

  int halted;			/* Is the Z80 currently HALTed? */

  /* RAM */

  libspectrum_byte *pages[8];

  /* Data from .slt files */

  libspectrum_byte *slt[256];	/* Level data */
  size_t slt_length[256];	/* Length of each level */

  libspectrum_byte *slt_screen;	/* Loading screen */
  int slt_screen_level;		/* The id of the loading screen. Not used
				   for anything AFAIK, but I'll copy it
				   around just in case */

  /* Peripheral status */

  libspectrum_byte out_ula; libspectrum_dword tstates;

  libspectrum_byte out_128_memoryport;

  libspectrum_byte out_ay_registerport, ay_registers[16];

  libspectrum_byte out_plus3_memoryport;

  /* Timex-specific bits */
  libspectrum_byte out_scld_hsr, out_scld_dec;

};

/* Initialise a libspectrum_snap structure */
libspectrum_error
libspectrum_snap_alloc( libspectrum_snap **snap )
{
  int i;

  (*snap) = malloc( sizeof( libspectrum_snap ) );
  if( !(*snap) ) {
    libspectrum_print_error( LIBSPECTRUM_ERROR_MEMORY,
			     "libspectrum_snap_alloc: out of memory" );
    return LIBSPECTRUM_ERROR_MEMORY;
  }

  libspectrum_snap_set_a   ( *snap, 0x00 );
  libspectrum_snap_set_f   ( *snap, 0x00 );
  libspectrum_snap_set_bc  ( *snap, 0x0000 );
  libspectrum_snap_set_de  ( *snap, 0x0000 );
  libspectrum_snap_set_hl  ( *snap, 0x0000 );

  libspectrum_snap_set_a_  ( *snap, 0x00 );
  libspectrum_snap_set_f_  ( *snap, 0x00 );
  libspectrum_snap_set_bc_ ( *snap, 0x0000 );
  libspectrum_snap_set_de_ ( *snap, 0x0000 );
  libspectrum_snap_set_hl_ ( *snap, 0x0000 );

  libspectrum_snap_set_ix  ( *snap, 0x0000 );
  libspectrum_snap_set_iy  ( *snap, 0x0000 );
  libspectrum_snap_set_i   ( *snap, 0x00 );
  libspectrum_snap_set_r   ( *snap, 0x00 );
  libspectrum_snap_set_sp  ( *snap, 0x0000 );
  libspectrum_snap_set_pc  ( *snap, 0x0000 );

  libspectrum_snap_set_iff1( *snap, 1 );
  libspectrum_snap_set_iff2( *snap, 1 );
  libspectrum_snap_set_im  ( *snap, 1 );

  libspectrum_snap_set_halted( *snap, 0 );

  for( i = 0; i < 8; i++ ) libspectrum_snap_set_pages( *snap, i, NULL );
  for( i = 0; i < 256; i++ ) {
    libspectrum_snap_set_slt( *snap, i, NULL );
    libspectrum_snap_set_slt_length( *snap, i, 0 );
  }
  libspectrum_snap_set_slt_screen( *snap, NULL );
  libspectrum_snap_set_slt_screen_level( *snap, 0 );

  libspectrum_snap_set_out_ula( *snap, 0x00 );
  libspectrum_snap_set_tstates( *snap, 69664 );
  libspectrum_snap_set_out_128_memoryport( *snap, 0x07 );

  libspectrum_snap_set_out_ay_registerport( *snap, 0x0e );
  for( i = 0; i < 16; i++ ) libspectrum_snap_set_ay_registers( *snap, i, 0 );

  libspectrum_snap_set_out_plus3_memoryport( *snap, 0x08 );

  libspectrum_snap_set_out_scld_hsr( *snap, 0x00 );
  libspectrum_snap_set_out_scld_dec( *snap, 0x00 );

  return LIBSPECTRUM_ERROR_NONE;
}

libspectrum_machine
libspectrum_snap_machine( libspectrum_snap *snap )
{
  return snap->machine;
}

void
libspectrum_snap_set_machine( libspectrum_snap *snap, libspectrum_machine machine )
{
  snap->machine = machine;
}

libspectrum_byte
libspectrum_snap_a( libspectrum_snap *snap )
{
  return snap->a;
}

void
libspectrum_snap_set_a( libspectrum_snap *snap, libspectrum_byte a )
{
  snap->a = a;
}

libspectrum_byte
libspectrum_snap_f( libspectrum_snap *snap )
{
  return snap->f;
}

void
libspectrum_snap_set_f( libspectrum_snap *snap, libspectrum_byte f )
{
  snap->f = f;
}

libspectrum_word
libspectrum_snap_bc( libspectrum_snap *snap )
{
  return snap->bc;
}

void
libspectrum_snap_set_bc( libspectrum_snap *snap, libspectrum_word bc )
{
  snap->bc = bc;
}

libspectrum_word
libspectrum_snap_de( libspectrum_snap *snap )
{
  return snap->de;
}

void
libspectrum_snap_set_de( libspectrum_snap *snap, libspectrum_word de )
{
  snap->de = de;
}

libspectrum_word
libspectrum_snap_hl( libspectrum_snap *snap )
{
  return snap->hl;
}

void
libspectrum_snap_set_hl( libspectrum_snap *snap, libspectrum_word hl )
{
  snap->hl = hl;
}

libspectrum_byte
libspectrum_snap_a_( libspectrum_snap *snap )
{
  return snap->a_;
}

void
libspectrum_snap_set_a_( libspectrum_snap *snap, libspectrum_byte a_ )
{
  snap->a_ = a_;
}

libspectrum_byte
libspectrum_snap_f_( libspectrum_snap *snap )
{
  return snap->f_;
}

void
libspectrum_snap_set_f_( libspectrum_snap *snap, libspectrum_byte f_ )
{
  snap->f_ = f_;
}

libspectrum_word
libspectrum_snap_bc_( libspectrum_snap *snap )
{
  return snap->bc_;
}

void
libspectrum_snap_set_bc_( libspectrum_snap *snap, libspectrum_word bc_ )
{
  snap->bc_ = bc_;
}

libspectrum_word
libspectrum_snap_de_( libspectrum_snap *snap )
{
  return snap->de_;
}

void
libspectrum_snap_set_de_( libspectrum_snap *snap, libspectrum_word de_ )
{
  snap->de_ = de_;
}

libspectrum_word
libspectrum_snap_hl_( libspectrum_snap *snap )
{
  return snap->hl_;
}

void
libspectrum_snap_set_hl_( libspectrum_snap *snap, libspectrum_word hl_ )
{
  snap->hl_ = hl_;
}

libspectrum_word
libspectrum_snap_ix( libspectrum_snap *snap )
{
  return snap->ix;
}

void
libspectrum_snap_set_ix( libspectrum_snap *snap, libspectrum_word ix )
{
  snap->ix = ix;
}

libspectrum_word
libspectrum_snap_iy( libspectrum_snap *snap )
{
  return snap->iy;
}

void
libspectrum_snap_set_iy( libspectrum_snap *snap, libspectrum_word iy )
{
  snap->iy = iy;
}

libspectrum_byte
libspectrum_snap_i( libspectrum_snap *snap )
{
  return snap->i;
}

void
libspectrum_snap_set_i( libspectrum_snap *snap, libspectrum_byte i )
{
  snap->i = i;
}

libspectrum_byte
libspectrum_snap_r( libspectrum_snap *snap )
{
  return snap->r;
}

void
libspectrum_snap_set_r( libspectrum_snap *snap, libspectrum_byte r )
{
  snap->r = r;
}

libspectrum_word
libspectrum_snap_sp( libspectrum_snap *snap )
{
  return snap->sp;
}

void
libspectrum_snap_set_sp( libspectrum_snap *snap, libspectrum_word sp )
{
  snap->sp = sp;
}

libspectrum_word
libspectrum_snap_pc( libspectrum_snap *snap )
{
  return snap->pc;
}

void
libspectrum_snap_set_pc( libspectrum_snap *snap, libspectrum_word pc )
{
  snap->pc = pc;
}

libspectrum_byte
libspectrum_snap_iff1( libspectrum_snap *snap )
{
  return snap->iff1;
}

void
libspectrum_snap_set_iff1( libspectrum_snap *snap, libspectrum_byte iff1 )
{
  snap->iff1 = iff1;
}

libspectrum_byte
libspectrum_snap_iff2( libspectrum_snap *snap )
{
  return snap->iff2;
}

void
libspectrum_snap_set_iff2( libspectrum_snap *snap, libspectrum_byte iff2 )
{
  snap->iff2 = iff2;
}

libspectrum_byte
libspectrum_snap_im( libspectrum_snap *snap )
{
  return snap->im;
}

void
libspectrum_snap_set_im( libspectrum_snap *snap, libspectrum_byte im )
{
  snap->im = im;
}

libspectrum_dword
libspectrum_snap_tstates( libspectrum_snap *snap )
{
  return snap->tstates;
}

void
libspectrum_snap_set_tstates( libspectrum_snap *snap, libspectrum_dword tstates )
{
  snap->tstates = tstates;
}

int
libspectrum_snap_halted( libspectrum_snap *snap )
{
  return snap->halted;
}

void
libspectrum_snap_set_halted( libspectrum_snap *snap, int halted )
{
  snap->halted = halted;
}

libspectrum_byte
libspectrum_snap_out_ula( libspectrum_snap *snap )
{
  return snap->out_ula;
}

void
libspectrum_snap_set_out_ula( libspectrum_snap *snap, libspectrum_byte out_ula )
{
  snap->out_ula = out_ula;
}

libspectrum_byte
libspectrum_snap_out_128_memoryport( libspectrum_snap *snap )
{
  return snap->out_128_memoryport;
}

void
libspectrum_snap_set_out_128_memoryport( libspectrum_snap *snap, libspectrum_byte out_128_memoryport )
{
  snap->out_128_memoryport = out_128_memoryport;
}

libspectrum_byte
libspectrum_snap_out_plus3_memoryport( libspectrum_snap *snap )
{
  return snap->out_plus3_memoryport;
}

void
libspectrum_snap_set_out_plus3_memoryport( libspectrum_snap *snap, libspectrum_byte out_plus3_memoryport )
{
  snap->out_plus3_memoryport = out_plus3_memoryport;
}

libspectrum_byte
libspectrum_snap_out_ay_registerport( libspectrum_snap *snap )
{
  return snap->out_ay_registerport;
}

void
libspectrum_snap_set_out_ay_registerport( libspectrum_snap *snap, libspectrum_byte out_ay_registerport )
{
  snap->out_ay_registerport = out_ay_registerport;
}

libspectrum_byte
libspectrum_snap_ay_registers( libspectrum_snap *snap, int idx )
{
  return snap->ay_registers[idx];
}

void
libspectrum_snap_set_ay_registers( libspectrum_snap *snap, int idx, libspectrum_byte ay_registers )
{
  snap->ay_registers[idx] = ay_registers;
}

libspectrum_byte
libspectrum_snap_out_scld_hsr( libspectrum_snap *snap )
{
  return snap->out_scld_hsr;
}

void
libspectrum_snap_set_out_scld_hsr( libspectrum_snap *snap, libspectrum_byte out_scld_hsr )
{
  snap->out_scld_hsr = out_scld_hsr;
}

libspectrum_byte
libspectrum_snap_out_scld_dec( libspectrum_snap *snap )
{
  return snap->out_scld_dec;
}

void
libspectrum_snap_set_out_scld_dec( libspectrum_snap *snap, libspectrum_byte out_scld_dec )
{
  snap->out_scld_dec = out_scld_dec;
}

libspectrum_byte*
libspectrum_snap_pages( libspectrum_snap *snap, int idx )
{
  return snap->pages[idx];
}

void
libspectrum_snap_set_pages( libspectrum_snap *snap, int idx, libspectrum_byte* pages )
{
  snap->pages[idx] = pages;
}

libspectrum_byte*
libspectrum_snap_slt( libspectrum_snap *snap, int idx )
{
  return snap->slt[idx];
}

void
libspectrum_snap_set_slt( libspectrum_snap *snap, int idx, libspectrum_byte* slt )
{
  snap->slt[idx] = slt;
}

size_t
libspectrum_snap_slt_length( libspectrum_snap *snap, int idx )
{
  return snap->slt_length[idx];
}

void
libspectrum_snap_set_slt_length( libspectrum_snap *snap, int idx, size_t slt_length )
{
  snap->slt_length[idx] = slt_length;
}

libspectrum_byte*
libspectrum_snap_slt_screen( libspectrum_snap *snap )
{
  return snap->slt_screen;
}

void
libspectrum_snap_set_slt_screen( libspectrum_snap *snap, libspectrum_byte* slt_screen )
{
  snap->slt_screen = slt_screen;
}

int
libspectrum_snap_slt_screen_level( libspectrum_snap *snap )
{
  return snap->slt_screen_level;
}

void
libspectrum_snap_set_slt_screen_level( libspectrum_snap *snap, int slt_screen_level )
{
  snap->slt_screen_level = slt_screen_level;
}
