/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2006 Takuro Ashie
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "tomoe-scrollable.h"

enum {
    SET_SCROLL_ADJUSTMENTS_SIGNAL,
    LAST_SIGNAL
};

static void tomoe_scrollable_base_init  (gpointer g_class);

static gint scrollable_signals[LAST_SIGNAL] = {0};

GType
tomoe_scrollable_get_type (void)
{
    static GType type = 0;
    if (!type)
    {
        static const GTypeInfo info = {
            sizeof (TomoeScrollableIFace),
            tomoe_scrollable_base_init, /* base_init :*/
            NULL,                       /* base_finalize */
            NULL,                       /* class_init */
            NULL,                       /* class_finalize */
            NULL,                       /* class_data */
            0,
            0,                          /* n_preallocs */
            NULL,                       /* instance_init */
        };
        type = g_type_register_static(G_TYPE_INTERFACE, "TomoeScrollable",
                                      &info, 0);
        g_type_interface_add_prerequisite(type, G_TYPE_OBJECT);
    }
    return type;
}

static void
tomoe_scrollable_base_init (gpointer g_class)
{
    static gboolean initialized = FALSE;

    if (initialized) return;

    scrollable_signals[SET_SCROLL_ADJUSTMENTS_SIGNAL] =
        g_signal_new ("set_scroll_adjustments",
                      G_TYPE_FROM_CLASS (g_class),
                      G_SIGNAL_RUN_LAST,
                      G_STRUCT_OFFSET(TomoeScrollableIFace, set_adjustments),
		      NULL, NULL,
                      gtk_marshal_NONE__POINTER_POINTER,
                      G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_POINTER);

    initialized = TRUE;
}

void
tomoe_scrollable_setup_widget_class (GtkWidgetClass *klass)
{
    g_return_if_fail (GTK_IS_WIDGET_CLASS (klass));

    klass->set_scroll_adjustments_signal
        = scrollable_signals[SET_SCROLL_ADJUSTMENTS_SIGNAL];
}

void
tomoe_scrollable_get_adjustments (TomoeScrollable *scrollable,
                                  GtkAdjustment  **h_adj,
                                  GtkAdjustment  **v_adj)
{
    g_return_if_fail (TOMOE_IS_SCROLLABLE (scrollable));
    g_return_if_fail (TOMOE_SCROLLABLE_GET_IFACE (scrollable)->get_adjustments);
}

void
tomoe_scrollable_set_adjustments (TomoeScrollable *scrollable,
                                  GtkAdjustment   *h_adj,
                                  GtkAdjustment   *v_adj)
{
    g_return_if_fail (TOMOE_IS_SCROLLABLE (scrollable));
    gtk_widget_set_scroll_adjustments (GTK_WIDGET (scrollable), h_adj, v_adj);
}

void
tomoe_scrollable_set_own_adjustments (TomoeScrollable *scrollable)
{
    GtkAdjustment *h_adj, *v_adj;

    g_return_if_fail (TOMOE_IS_SCROLLABLE (scrollable));

    h_adj = GTK_ADJUSTMENT (gtk_adjustment_new (0.0, 0.0, 1.0, 0.05, 0.1, 0.1));
    v_adj = GTK_ADJUSTMENT (gtk_adjustment_new (0.0, 0.0, 1.0, 0.05, 0.1, 0.1));

    /* FIXME!: need sink? */

    tomoe_scrollable_set_adjustments (scrollable, h_adj, v_adj);

    g_object_unref (h_adj);
    g_object_unref (h_adj);
}

void
tomoe_scrollable_h_page_up (TomoeScrollable *scrollable)
{
    GtkAdjustment *h_adj = NULL;
    gdouble value;

    tomoe_scrollable_get_adjustments (scrollable, &h_adj, NULL);
    g_return_if_fail (h_adj);

    value = h_adj->value - h_adj->page_increment;
    value = CLAMP (value, h_adj->lower, h_adj->upper - h_adj->page_size);
    gtk_adjustment_set_value (h_adj, value);
}

void
tomoe_scrollable_h_page_down (TomoeScrollable *scrollable)
{
    GtkAdjustment *h_adj = NULL;
    gdouble value;

    tomoe_scrollable_get_adjustments (scrollable, &h_adj, NULL);
    g_return_if_fail (h_adj);

    value = h_adj->value + h_adj->page_increment;
    value = CLAMP (value, h_adj->lower, h_adj->upper - h_adj->page_size);
    gtk_adjustment_set_value (h_adj, value);
}

void
tomoe_scrollable_v_page_up (TomoeScrollable *scrollable)
{
    GtkAdjustment *v_adj = NULL;
    gdouble value;

    tomoe_scrollable_get_adjustments (scrollable, &v_adj, NULL);
    g_return_if_fail (v_adj);

    value = v_adj->value - v_adj->page_increment;
    value = CLAMP (value, v_adj->lower, v_adj->upper - v_adj->page_size);
    gtk_adjustment_set_value (v_adj, value);
}

void
tomoe_scrollable_v_page_down (TomoeScrollable *scrollable)
{
    GtkAdjustment *v_adj = NULL;
    gdouble value;

    tomoe_scrollable_get_adjustments (scrollable, &v_adj, NULL);
    g_return_if_fail (v_adj);

    value = v_adj->value + v_adj->page_increment;
    value = CLAMP (value, v_adj->lower, v_adj->upper - v_adj->page_size);
    gtk_adjustment_set_value (v_adj, value);
}
/*
 * vi:ts=4:nowrap:ai:expandtab
 */
