/****************************************************************************
**
** $Id: FileListView.cpp,v 1.9 2004/02/26 01:20:15 hemer Exp $
**
** Copyright (C) 2001-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

//----------------------------------------------------------------------------

#include <qdragobject.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <qheader.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "FileListView.h"

//----------------------------------------------------------------------------

CFileListView::CFileListView(QWidget * parent, const char * name)
  : QListView(parent, name), m_absPath("")
{
  m_bSelected = false;
}

//----------------------------------------------------------------------------

void CFileListView::viewportMouseMoveEvent(QMouseEvent * e)
{
   if (!globalListViewsEnabled) return;

   QListView::viewportMouseMoveEvent( e );

   if (e->state() == LeftButton) {
     QStringList fileNames = getNamesOfSelectedFiles();
     
     QStrList uris;
     uris.setAutoDelete(true);   //should be true by default
     
     QStringList::Iterator it;
     for (it = fileNames.begin(); it != fileNames.end(); ++it) {
       uris.append(QUriDrag::localFileToUri(*it));
     }
     
     QUriDrag *d = new QUriDrag( uris, this );
     emit dragStarted();
     d->drag();
     emit dragDone();
   }
}

//----------------------------------------------------------------------------

void CFileListView::selFile( QListViewItem * It )
{
  clearSelection();
  emit doubleClickedFile( It->text(0) );
}

//----------------------------------------------------------------------------

void CFileListView::selectionChanged() 
{
  bool tmp = false;

  QListViewItem *myChild = firstChild();
  while(myChild) {
    if (myChild->isSelected()) {
      tmp = true;
      break;
    }
    myChild = myChild->nextSibling();
  }

  m_bSelected = tmp;
  emit showFileMenu(m_bSelected);
}

//----------------------------------------------------------------------------

QStringList CFileListView::getNamesOfSelectedFiles(bool bWithPath /* = true */)
{
   QStringList fileNames;
    
   QListViewItem *myChild = firstChild();
   while(myChild) {
       if(myChild->isSelected()) {
	 if (bWithPath) {
	   fileNames.append(m_absPath + myChild->text(0));
	 } else {
	   fileNames.append(myChild->text(0));
	 }
       }

       myChild = myChild->nextSibling();
   }

   return fileNames;
}

//----------------------------------------------------------------------------

QStringList CFileListView::copyToClipboard() {

  QClipboard *cb = QApplication::clipboard();

  QStringList fileList = getNamesOfSelectedFiles();
     
  QUriDrag *d = new QUriDrag( this );
  d->setFileNames(fileList);

  cb->setData(d,QClipboard::Clipboard);
  return fileList;
}

//----------------------------------------------------------------------------

void CFileListView::setHeaderSetup(QString hs) {
  unsigned int i;
  for (i = 0; i<hs.length(); ++i) {
    header()->moveSection(i,hs.mid(i,1).toInt());
  }
}

//----------------------------------------------------------------------------

QString CFileListView::getHeaderSetup() {

  int i;
  QString hs;
  for (i = 0; i<header()->count(); ++i) {
    hs += QString::number(header()->mapToIndex(i));
  }
  return hs;
}

//----------------------------------------------------------------------------
