/******************************************************************************
 *   Copyright (C) 2005 by la9527                                             *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      * 
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.*
 ******************************************************************************/
#include "mlslog.h"
#include "strutil.h"

namespace MLSUTIL
{
	MlsLog	g_Log;
	
	void	MlsLog::Write(const string& sStr)
	{
		#ifdef __DEBUGMODE__
		if (!_bLog) return;
		ofstream	fp(_LogFile.c_str(), ios::out|ios::app);

		if (fp.is_open())
		{
			fp.write(sStr.c_str(), sStr.size());
			fp.write("\n", 1);
		}
		#endif
	}
	
	void	MlsLog::Write(const char* fmt, ...)
	{
		#ifdef __DEBUGMODE__
		if (!_bLog) return;

		va_list argptr;
		char buf_data[256];
		char* data = buf_data;
		int data_size = sizeof(buf_data);
		int ret;
		memset(&buf_data, 0, sizeof(buf_data));
		va_start(argptr, fmt);
		ret = vsnprintf(data, data_size, fmt, argptr);
		++ret;
		va_end(argptr);
		
		if(ret > (int)sizeof(buf_data))
		{
			data = (char*)malloc(ret+1);
			if (data == NULL)
			{
				cerr << "Buffer over flow" << endl;
				return;
			}
			memset(data, 0, sizeof(char)*(ret+1));
			data_size = ret+1;
			strcat(data, "\n");
			va_start(argptr, fmt);
			vsnprintf(data, data_size, fmt, argptr);
			va_end(argptr);
		}
		else
		{
			strcat(data, "\n");
		}

		ofstream	 fp(_LogFile.c_str(), ios::out|ios::app);
			
		if (fp.is_open())
		{
			fp.write(data, data_size);
		}

		if(data != buf_data)
		{
			if (data != NULL) free(data);
		}
		#endif
	}
};
