#include "cmd_common_imp.h"
#include "mainframe.h"

using namespace MLS;
using namespace MLSUTIL;

void	CmdCommonImp::About()
{
	vector<string>	vAbout;
	String			str;

	str.Printf( ChgEngKor("LinM %s - User-Interfaced File Manager ", 
				          "LinM %s - 심플한 파일 관리자 ").c_str(), VERSION);
	vAbout.push_back( str.c_str() );
	vAbout.push_back( "" );
	vAbout.push_back( ChgEngKor("Author : ",
								"작성자  : " ) );
	vAbout.push_back( ChgEngKor("  Project Manager : Byoungyoung, La (la9527@yahoo.co.kr)",
					            "  프로젝트관리자   : 라병영 (la9527@yahoo.co.kr)") );
	vAbout.push_back( ChgEngKor("  Develper        : IOKLO (leesjung@nownuri.net)",
								"  개발자           : IOKLO (leesjung@nownuri.net)") );
	vAbout.push_back( ChgEngKor("  Tester          : Leem ChaeHoon (infiniterun@gmail.com)",
								"  테스터           : 임채훈 (infiniterun@gmail.com)") );
	vAbout.push_back( ChgEngKor("  Translator      : Eunseo, Choi (eunseo.choi@gmail.com)",
								"  영작             : 최은서 (eunseo.choi@gmail.com)") );
	vAbout.push_back( "" );	
	vAbout.push_back( ChgEngKor("  * Project homepage : http://mls.kldp.net", 
								"  * 프로젝트 홈페이지 : http://mls.kldp.net") );
	vAbout.push_back( "" );
	vAbout.push_back( "(c) 2006 The Mls Developers" );
	TextListBox( _("About"), vAbout );
}

void	CmdCommonImp::Help()
{
	vector<string>	vMsgData;
	String			sMsg;
	string			sCmd;
	string 			sView;
	
	vMsgData.push_back("-----------------------------------------------------------------");
    vMsgData.push_back(_("LinM Key List"));
	vMsgData.push_back("-----------------------------------------------------------------");
    vMsgData.push_back("");

	vMsgData.push_back( _("File Panel Key List") );

	map<TypeInfo*, string>::iterator i;

	for (i = g_tKeyCfg._mapKeyHelp.begin(); i != g_tKeyCfg._mapKeyHelp.end(); ++i)
	{
		if ( i->first->eType == PANEL || i->first->eType == COMMON )
		{
			string sKeyName = g_tKeyCfg.CmdToKeyName( i->first->sValue, i->first->eType );

			if (sKeyName.size() > 1 )
				if ( sKeyName[0] == 'F' && (sKeyName[1] > '0' && sKeyName[1] <= '9'))
					continue;

			if ( !sKeyName.empty() && sKeyName != i->second)
			{
				sView = g_tKeyCfg.GetHelp( i->first->sValue, i->first->eType );
				
				sMsg.Printf("    %-10s : %s", sKeyName.c_str(), sView.c_str());
				vMsgData.push_back(sMsg.c_str());
			}
		}
	}

	vMsgData.push_back("");
	vMsgData.push_back( _("LinM Change Directory Key List") );

	for (i = g_tKeyCfg._mapKeyHelp.begin(); i != g_tKeyCfg._mapKeyHelp.end(); ++i)
	{
		if ( i->first->eType == MCD || i->first->eType == COMMON )
		{
			string sKeyName = g_tKeyCfg.CmdToKeyName( i->first->sValue, i->first->eType );

			if (sKeyName.size() > 1 )
				if ( sKeyName[0] == 'F' && (sKeyName[1] > '0' && sKeyName[1] <= '9'))
					continue;

			if ( !sKeyName.empty() && sKeyName != i->second)
			{
				sView = g_tKeyCfg.GetHelp( i->first->sValue, i->first->eType );

				sMsg.Printf("    %-10s : %s", sKeyName.c_str(), sView.c_str());
				vMsgData.push_back(sMsg.c_str());
			}
		}
	}

	vMsgData.push_back("");
	vMsgData.push_back( _("Simple Editor Key List") );

	for (i = g_tKeyCfg._mapKeyHelp.begin(); i != g_tKeyCfg._mapKeyHelp.end(); ++i)
	{
		if ( i->first->eType == EDITOR || i->first->eType == COMMON )
		{
			string sKeyName = g_tKeyCfg.CmdToKeyName( i->first->sValue, i->first->eType );

			if (sKeyName.size() > 1 )
				if ( sKeyName[0] == 'F' && (sKeyName[1] > '0' && sKeyName[1] <= '9'))
					continue;

			if ( !sKeyName.empty() && sKeyName != i->second)
			{
				sView = g_tKeyCfg.GetHelp( i->first->sValue, i->first->eType );

				sMsg.Printf("    %-10s : %s", sKeyName.c_str(), sView.c_str());
				vMsgData.push_back(sMsg.c_str());
			}
		}
	}

	vMsgData.push_back("");

	vMsgData.push_back("-----------------------------------------------------------------");
    vMsgData.push_back( _("LinM Function Key List") );
	vMsgData.push_back("-----------------------------------------------------------------");

	vMsgData.push_back( "" );
	vMsgData.push_back( _("File Panel Function Key List") );
	vMsgData.push_back( "" );

	for (int i=1; i<= 12; i++)
	{
		sMsg.Printf("F%d", i);
		sCmd = g_tKeyCfg.GetCommand( sMsg.c_str(), PANEL );
		sCmd = g_tKeyCfg.GetHelp( sCmd, PANEL );
		if ( !sCmd.empty() )
		{
			sMsg.Printf("    %-10s : %s", sMsg.c_str(), _(sCmd.c_str()));
			vMsgData.push_back(sMsg.c_str());
		}
	}

	vMsgData.push_back( "" );
	vMsgData.push_back( _("LinM Change Directory Function Key List") );

	for (int i=1; i<= 12; i++)
	{
		sMsg.Printf("F%d", i);
		sCmd = g_tKeyCfg.GetCommand( sMsg.c_str(), MCD );
		sCmd = g_tKeyCfg.GetHelp( sCmd, MCD );
		if ( !sCmd.empty() )
		{
			sMsg.Printf("    %-10s : %s", sMsg.c_str(), _(sCmd.c_str()));
			vMsgData.push_back(sMsg.c_str());
		}
	}

	vMsgData.push_back( "" );
	vMsgData.push_back( _("Simple Editor Function Key List") );
	vMsgData.push_back( "" );

	for (int i=1; i<= 12; i++)
	{
		sMsg.Printf("F%d", i);
		sCmd = g_tKeyCfg.GetCommand( sMsg.c_str(), EDITOR );
		sCmd = g_tKeyCfg.GetHelp( sCmd, EDITOR );
		if ( !sCmd.empty() )
		{
			sMsg.Printf("    %-10s : %s", sMsg.c_str(), _(sCmd.c_str()));
			vMsgData.push_back(sMsg.c_str());
		}
	}
	
	TextListBox( _("Help"), vMsgData, true );
}


void	CmdCommonImp::ReloadConfigChange()
{
	if ( _pEditor->_bConfChg )
	{
		string sCfgHome, sDefault, sColor, sKeySet;
		sCfgHome = g_tCfg.GetValue("Static", "CfgHome");
		sDefault = g_tCfg.GetValue("Static", "CfgFile");
		sColor = g_tCfg.GetValue("Static", "ColFile");
		sKeySet = g_tCfg.GetValue("Static", "KeyFile");
		
		g_tCfg.Clear();
		g_tColorCfg.Clear();
		g_tKeyCfg.Clear();

		g_tCfg.Load(sDefault.c_str());
		g_tColorCfg.Load(sColor.c_str());
		g_tKeyCfg.Load(sKeySet.c_str());

		g_tCfg.SetStaticValue("CfgHome", sCfgHome);
		g_tCfg.SetStaticValue("CfgFile", sDefault);
		g_tCfg.SetStaticValue("ColFile", sColor);
		g_tCfg.SetStaticValue("KeyFile", sKeySet);

		_pEditor->_bConfChg = false;

		g_tMainFrame.Reload();
	}
}

void CmdCommonImp::BoxCodeChange()
{
	g_tMainFrame.LineCodeChange();
}

void CmdCommonImp::LangChange()
{
	if (e_nCurLang == US)
		Set_Locale(AUTO);
	else
		Set_Locale(US);
}
