/* Copyright (C) 2000-2003 Markus Lausser (sgop@users.sf.net)
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifndef GLOBAL_H_
#define GLOBAL_H_

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gtk/gtk.h"

#include "interface.h"
#include "lopster.h"

#ifdef HAVE_ZLIB
#  ifdef THREADS_ENABLED
#    define VERSION_STRING "Lopster [zt] "VERSION
#  else
#    define VERSION_STRING "Lopster [z] "VERSION
#  endif
#else
#  ifdef THREADS_ENABLED
#    define VERSION_STRING "Lopster [t] "VERSION
#  else
#    define VERSION_STRING "Lopster "VERSION
#  endif
#endif

extern const char LineSpeedShort[12][20];
extern char tstr[10][512];
extern char *list[10];
extern char Network[N_NUMBER][20];
extern int SocketStatus[S_NUMBER];
extern char* NetType[5];
extern const int ModeMask[N_NUMBER];
extern const char* ModeNames[MODE_NUMBER];
extern const char* CModeNames[CMODE_NUMBER];

#define LIB_LIST_TARGETS   2
extern const GtkTargetEntry lib_list_targets[LIB_LIST_TARGETS];

extern char **environ;
extern GtkCTree* DownloadTree[4];
extern GtkWidget* DownloadScroll[4];
extern GtkWidget* DownloadVbox[4];

#define DL_GET_NICK(download) \
  (((download) && (download)->nets)?((net_user_t*)((download)->nets->data))->user:NULL)
#define DL_GET_NET(download) \
  (((download) && (download)->nets)?((net_user_t*)((download)->nets->data))->net:NULL)

#define NET_IRC(net) ((net) && ((net)->type & NETWORK_IRC))
#define NET_NAP(net) ((net) && ((net)->type & NETWORK_NAPSTER))
#define NET_ONLINE(net) ((net) && (net)->active_server)
#define NET_CONNECTED(net) ((net) && (net)->active_server && (net)->active_server->status == SERVER_ONLINE)

#ifndef MSG_NOSIGNAL
#define MSG_NOSIGNAL 0
#endif

extern global_t global;

int ColorTable(int i1, int i2);
int ColorTable2(int index);

/* */
void detect_line_pixs(int speed, GdkPixmap ** pixmap, GdkBitmap ** bitmap);
void down_speed_pixs(double rate, GdkPixmap ** pixmap, GdkBitmap ** bitmap);
void up_speed_pixs(double rate, GdkPixmap ** pixmap, GdkBitmap ** bitmap);

/* string to int functions */
int speed2int     (char *linespeed);
int level2int     (char *level);
int status2int    (char *status);
int timestamp2int (char *stamp);
int browser2int   (char *browser);

/* int to string functions */
char* LineSpeed   (int no);
char* TimeNames   (int no);
char* UserStatus  (int status);
char* TimeStamp   (int id);
char* WebBrowser  (int browser);
char* Level       (int level);
char* LevelShort  (int level);

void browse_url(char *url);
int version_is_up_to_date(char *version);
int verify_speed(int speed);
int get_beats(time_t tim);
int guess_mime(char *suffix);
int find_valid_bitrate(int bitrate);
char *current_time(char *stime, int with_secs);
char *ntoa(unsigned int ip);

void update_reply(char *user, net_t *net, int highlight);
void update_status_line();
#ifndef HAVE_STRCASESTR
char *strcasestr(char *str, char *sub);
#endif


int idle_function(gpointer data);

void set_title();
void setup_global_vars();
void setup_main_tab();
void write_rc();

void global_init();
void global_exit();

gint browse_saved_compare(GtkCList * clist,
			  gconstpointer ptr1, gconstpointer ptr2);
gint channel_compare(GtkCList * clist,
		     gconstpointer ptr1, gconstpointer ptr2);
gint socket_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2);
gint transfer_compare(GtkCList * clist,
		      gconstpointer ptr1, gconstpointer ptr2);
gint download_compare(GtkCList * clist,
		      gconstpointer ptr1, gconstpointer ptr2);
gint download_compare2(GtkCList * clist,
		       gconstpointer ptr1, gconstpointer ptr2);
gint browse_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2);
gint lib_compare(GtkCList * clist,
		 gconstpointer ptr1, gconstpointer ptr2);
gint hotlist_compare(GtkCList * clist,
		     gconstpointer ptr1, gconstpointer ptr2);
gint access_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2);
gint
client_compare(GtkCList * clist, gconstpointer ptr1, gconstpointer ptr2);
gint resume_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2);

void send_search_request();

void make_list_from_string(GList ** glist, char *text, char *sep);
char *make_string_from_list(GList * glist, char *sep);
client_t *is_client_in_list(GList * glist, char *t);
char *is_string_in_list(GList * glist, char *t);
char *is_prefix_in_list(GList * glist, char *t);
int calc_list_prefix(GList * glist);
int calc_command_prefix(GList * glist);
void set_last_server(server_t * server);
void set_button_state(GtkWidget * button, int open);
int toggle_button_state(GtkWidget * button);
void set_up_button(GtkWidget * button, char *pix1, char *pix2, char *wid);
void set_up_button2(GtkWidget * button,
		    GtkWidget * pix1, GtkWidget * pix2, GtkWidget * wid);
void show_bans(net_t* net, char *channel);
char *cparse(char *input);
void client_message(const char *text, const char *fmt, ...);
void server_message(net_t* net, const char *fmt, ...);
void protocol_message(net_t* net, int direction, int type, char* text);

void toggle_friend(char *user);
void toggle_enemy(char *user);
void toggle_nodownload(char *user);

void opennap_notify();

GtkWidget *create_customize_win(GtkCList * clist, int* array);
void show_clients(net_t* net);
void show_global_users(net_t* net, char *args);

GtkWidget *create_mode_popup(void);
GtkWidget *create_user_popup(int mode, void* data);
void draw_band_width(bandwidth_t * bandwidth, int full);

void extra_win_get_geometry();
void advance_progress(char *message, gfloat per);
GtkWidget *main_tab_detach(int no);

int get_version(net_t* net, const char *data);
void get_server(net_t* net, char *data);
void clones_clear();

GList *create_allowed_ports(char *string);
int get_next_port(GList * list, int last);
char *create_string_from_ports(GList * list);
void destroy_string_list(GList * list);
int port_is_allowed(GList * list, int port);

void gtk_my_widget_show(GtkWidget * widget);
void gtk_my_widget_show_all();

void switch_to_page(int no);
int notebook_page_visible(int no);
int notebook_page_current();

void print_topright_corner();
void set_user_level(net_t* net, int level);
void file_move(char* src, char* dest);
void ban_user(net_t* net, char* user, char* reason, long timeout);
void update_queue_length();
void send_user_status(net_t* net, char* user);

char *resolveip(const char *ip);
void ban_networks_load();
int ban_networks_scan(const char *ip);

void download_layout(download_layout_t* new_layout);

double global_queue_size();
int chmode2int_lop(char* mode, int* chmode1, int* chmode2);
char* int2chmode_lop(int set, int clear);
GtkWidget* create_open_menu(int type, char* name, int active);

void get_online_server(char* message);
void send_online_servers(net_t* net, char* user);

#endif
