#include "absplayer.h"
#include "absutil.h"

IntSetting absPlayer::SettingPlaylistTrim("mediaplayer","trim",1);
IntSetting absPlayer::SettingPlaylistTrimVal("mediaplayer","trimval",20);

absPlayer* absPlayer::getPlayer() {
	return _player;
}

void absPlayer::setPlayer(absPlayer* player) {
	_player  = player;
}
absPlayer* absPlayer::_player = 0;

void absPlayer::subscribe(LPListener* lplayer) {
	_listeners.push_back(lplayer);
}

absPlayer::~absPlayer() {
	brun = false;
	brunning = false;
}

void absPlayer::run() {
	logDebug("LPAMP::starting song detect loop.");
	brun = true;
	brunning = true;
	currenttitle = "";
	string tmp;
	bool playing=false;
	bool nearedEnd=false;
	bool eoPlaylist=false;
	while (brun)
	{
		//note that first, songname is called; players can set all their vars in that method and cache the rest
		tmp = getRSongName();
		if (
			((currenttitle != tmp) && 
			(!tmp.empty()) && 
			(getRSongLength() > 0)) ||
			(isPlaying()!=playing)			
			)
		{
			//a new song!!
			nearedEnd = false; 
			playing=isPlaying();
			currenttitle = tmp;
			currentfilename = getRFileName();
			currentlength = getRSongLength();
			if (tmp != getRSongName()) currenttitle = ""; //apparently the song has changed a second time already, so the data is invalid
			else 
			{
				eoPlaylist = endOfPlaylist();
				notifyListeners();
			}
		}
		else
		{
			if (!nearedEnd && eoPlaylist)
			{
			logDebug("end of song/playlist");
			nearedEnd = true; //notify only once
			notifyListeners();
			}
		}
		//my AppleScript calls are CPU intensive :(
		#ifdef Q_OS_MACX
		this->usleep(400000);
		//this->usleep(1000000);
		#else
		this->usleep(200000);
		#endif
	}
	brunning = false;
}

bool absPlayer::endOfPlaylist() const
{
	//logDebug(string("position: ") + absUtil::its(getSongPosition() ));
	if (	
        !(getPlaylistLength() - getPlaylistPosition()) && //last file
        (isPlaying()) && //playing
        ((getSongLength() - getSongPosition()) < 20) //20 seconds before end of playlist occurs
	)
	return true;
	else return false;
}
void absPlayer::notifyListeners()
{
	for (uint i=0;i < _listeners.size();i++)
		_listeners[i]->notify();
}
string absPlayer::getFileName() const
{
	return currentfilename;
}

int absPlayer::getSongLength() const
{
	return currentlength;
}
string absPlayer::getSongName() const
{
	return currenttitle;
}

void absPlayer::checkPlayed() { 
    if (getPlaylistPosition() > 2) {
        if (getSettings()->getSetting(SettingPlaylistTrim))
        cleanPlayed(getSettings()->getSetting(SettingPlaylistTrimVal));
    }
}

void absPlayer::setSettings(LPSettings* s) { _settings=s; }
LPSettings* absPlayer::getSettings() { return _settings; }
