#include <ctype.h>
#include <fstream> 
#include <sys/stat.h>
#include <time.h>
#include <sstream>
#include <string>
#include <iostream> // TEMPORARY

#include "lpglobal.h"
#include "absutil.h"

#include <qfileinfo.h>
#include <qfile.h>
#include <qdatetime.h>

#ifdef _WS_WIN_
	#include "windows.h"
#endif

absUtil* absUtil::util=0;
absUtil::absUtil() { init(); }
absUtil* absUtil::getUtil() { return util; }

//pre: lowerb <= upperb
int absUtil::randomNumber( int lowerb, int upperb ) {
    int mask=0;
    int random=0;
    int interval = upperb - lowerb;
    if ( interval == 0) return upperb;
	
	//construct bitmask that is greater or equal than the interval
	for (mask = 2; mask < interval; mask <<= 1) { }
	mask--; //"000011111 instead of 00010000" 
	random = randomMM() & mask + lowerb;
	//if not completely right, just retry
	while (random > upperb) 
		random = randomMM() & mask + lowerb;
    return random;
}

//thanks to Knuth...
int absUtil::randomMM() {
    int *piState;
    int iState1;
    int iState2;
    int iRand;
    piState	= &rgiState[2];
    iState1	= piState[-2];
    iState2	= piState[-1];
    iRand 	= ( piState[iState1] + piState[iState2] )
    			& ( ( 1 << 30 ) - 1 );
    piState[iState1]	= iRand;
    if ( ++iState1 == 55 )
    	iState1 = 0;
    if ( ++iState2 == 55 )
    	iState2 = 0;
    piState[-2]	= iState1;
    piState[-1]	= iState2;
    return iRand >> 6;
}

void absUtil::initRandomGenerator( ) {
    int *piState;
    int iState;
    int msecs;

/** added by spike; does not always work 
    // Get milliseconds 
    time_t ltime;
    if (time(&ltime) != 0) {
        logWarning(string("absUtil::date(): couldn't get time of day"));
        msecs = 0;
    }
    else {
        msecs = (int) ltime;
    }
*/
	msecs = ( (int) (QTime::currentTime()).msecsTo(QTime(0,0,0) ));

    piState	= &rgiState[2];
    piState[-2]	= 55 - 55;
    piState[-1]	= 55 - 24;
    piState[0]	= msecs & ( ( 1 << 30 ) - 1 );
    piState[1]	= 1;
    for ( iState = 2; iState < 55; iState++ ) {
        	piState[iState] = ( piState[iState-1] + piState[iState-2] )
        			& ( ( 1 << 30 ) - 1 );
    }
}

void absUtil::init() {
	initCRC32Table();
	initRandomGenerator();
}

void absUtil::setUtil(absUtil* newutil) { util = newutil; }

string absUtil::dts(double nr) {
    ostringstream str;
    str << nr;
    return str.str();
}

//hex notation
string absUtil::iths(uint nr) {
	char ch2[20];
    sprintf(ch2,"%X",nr);
    string c2 = string(ch2);
	//make it 8 characters.
	while (c2.length() < 8) c2 += "0";
	return uppercase(c2);
}

string absUtil::fts(float nr) {
    ostringstream str;
    str << nr;
    return str.str();
}

string absUtil::its(int nr) {
    ostringstream str;
    str << nr;
    return str.str();
}

string absUtil::shortTimeSpan(int secs) {
	int minutes = (secs % 3600) / 60;
	int seconds = secs % 60;
	return ((minutes<10) ? string(" ") + its(minutes) : its(minutes)) + ":" + ((seconds<10) ? string("0") + its(seconds) : its(seconds)) ;
}

string absUtil::milliTimeSpan(int msecs) {
	if (msecs < 1000) return its(msecs) + "msecs";
	if (msecs < 10000) return its(msecs / 1000) + "." + its((msecs % 1000) /10 ) + "secs"; 
	return longTimeSpan(msecs /1000);
}

string absUtil::longTimeSpan(int secs) {
	int months = secs / (3600*24*30);
	int weeks = (secs % (3600*24*30)) / (3600*24*7);
	int days = (secs % (3600*24*7)) / (3600*24);
	int hours = (secs % (3600*24)) / 3600;
	int minutes = (secs % 3600) / 60;
	int seconds = secs % 60;

	string result = ""; string sep = "";
	int acc = 2;

	if (months && acc) { result += sep + its(months) + (months > 1 ? "months": "month"); sep = " "; acc--; }
	if (weeks && acc) { result += sep + its(weeks) + (weeks > 1 ? "wks": "week"); sep = " "; acc--; }
	if (days && acc) { result += sep + its(days) + (days > 1 ? "days":"day"); sep = " "; acc--; }
	if (hours && acc) { result += sep + its(hours) + (hours > 1 ? "hrs":"hour"); sep = " "; acc--; }
	if (minutes && acc) { result += sep + its(minutes) + (minutes > 1 ? "mins" : "min"); sep = " "; acc--; }
	if (seconds && acc) { result += sep + its(seconds) + (seconds > 1 ? "secs" : "sec"); sep = " "; acc--; }

	return result;
}

double absUtil::random() {
	double rand = randomNumber(0,1000000000 )*0.00000005960517;
	return (rand > 1) ? 1 : rand;
}

int absUtil::getSize(string filename) {
	return QFileInfo(QString::fromLocal8Bit(filename.c_str())).size();
	/* added by spike; does not always work
    struct stat buf;
    if (stat(filename.c_str(),&buf) != 0) {
        logWarning(string("absUtil::getSize(): couldn't get statistics"));
        return 0;
    }
    else { 
        return (int) buf.st_size;
    }
	*/
}

int absUtil::date() {
	return QDateTime(QDate(1970,1,1), QTime(00,00)).secsTo(QDateTime::currentDateTime());
	/* added by spike, does not always work
    time_t ltime;
    if (time(&ltime) != 0) {
        logWarning(string("absUtil::date(): couldn't get time of day"));
        return 0;
    }
    else 
        return (int) ltime;
		*/
}

string absUtil::uppercase(string in) {
    string out(in);
    for (unsigned int i = 0; i < in.length(); i++) {
        out[i] = toupper(in[i]);
    }
    return out;
}

string absUtil::getFileID(string filename) {
    ifstream f;
    f.open(filename.c_str());
    if (!(f.is_open())) {
        logWarning(string("absUtil::getFileID(): Error opening file ")
                       + filename);
        return "";
    }

    /* Determine size */
    f.seekg(0,ios::end);
    int size = f.tellg();
    f.seekg (0,ios::beg);

    /* Read several blocks in buffer */
	char ubuf[28]; 
	//zero out the array, because in Windows there could be some bytes that are not filled
	//by the following reads
	for (int i = 0; i< 27; i++) ubuf[i] = 0; 

    char* buf = ubuf;
	if (size > 7) /* Minimum size */ {
		f.read(buf,4); buf += 4;
        f.seekg(size/5); f.read(buf,4); buf += 4;
        f.seekg(size-5); f.read(buf,4); buf += 4;
        f.seekg(size/3); f.read(buf,4); buf += 4;
		f.seekg(size/2); f.read(buf,4); buf += 4;
        f.seekg(size/6); f.read(buf,4);
	}
	else {
		logDebug("absUtil::skipping song (too small)");
		return "";
	}
	f.close();
    /* Calculate the CRC */

	//string result = ;
	//logDebug(filename + " gave " + result);

    return absUtil::iths(GetCRC((unsigned char*) ubuf,24));
}

bool absUtil::copyFile(string filename, string destination) {
	/*
	//this does NOT make an exact copy
	logDebug(string("copying file ") + filename + " to " + destination  );
    ifstream fin(filename.c_str());
    ofstream fout(destination.c_str(), ios_base::out | ios_base::trunc);
    if (!(fin.is_open() && fout.is_open())) {
        logWarning(string("Error copying file"));
        return false;
    }

    fout << fin.rdbuf();
    fin.close();
    fout.close();
	*/
	logDebug(string("copying file ") + filename + " to " + destination  );
    QFile fin(QString::fromLocal8Bit(filename.c_str()));
    if (!fin.open(IO_ReadOnly)) {
        logWarning(string("absUtil::Could not open file") + filename);
    	return false;
	}
	QString dest = QString::fromLocal8Bit(destination.c_str());
	QFile fout(dest);
    if (!fout.open(IO_WriteOnly)) {
        logWarning(string("absUtil::Could not open file ") + string(dest.local8Bit()));
		return false;    
	}
	long bytesRead;
	char* p = new char[65536];
	while ((bytesRead = fin.readBlock(p,65536))) {
		fout.writeBlock(p,bytesRead);
	}	
	fout.flush();
	fin.close(); fout.close();
	return true;
}

bool absUtil::existsFile(string filename) {
    struct stat buf;
    if (stat(filename.c_str(),&buf) != 0) {
        logDebug(filename + string(" doesn't exist"));
        return false;
    }
    else { 
        logDebug(filename + string(" exists"));
        return true;
    }
}

bool absUtil::removeFile(string filename,bool recyclebin) {
	if (!recyclebin) {
		if (!QFile::remove(QString::fromLocal8Bit(filename.c_str()))) 
		{ logWarning("absUtil::unable to delete"); return false; }
		return true;
	}
	else {
	#ifdef _WS_WIN_
		char param[1024];
		param[0] = '\0';
		strcat(param, filename.c_str());
		param[filename.size()+1] = '\0';//additional \0 to close list of filenames
		SHFILEOPSTRUCT si;
		ZeroMemory( &si, sizeof(si) );
		si.hwnd = 0;
		si.wFunc = FO_DELETE;
		si.pFrom = param;
		si.fFlags = FOF_ALLOWUNDO;
		si.lpszProgressTitle = "Deleting...";
		si.pTo = 0;
		si.hNameMappings = 0;
		si.fAnyOperationsAborted = 0;

		if( SHFileOperation( &si)) { logWarning("absUtil::unable to delete"); return false;}
		return true;
	#else
		if (!QFile::remove(QString::fromLocal8Bit(filename.c_str()))) 
		{ logWarning("absUtil::unable to delete"); return false; }
		return true;
	#endif
	}
}

/** pre-computes CRC-values in a table to speed up CRC32 calculation */
void absUtil::initCRC32Table() {
	logDebug("absUtil::CRC initing...");

    //the CRC32 polynomial
    uint poly = 0x04c11db7;

    // 256 values representing ASCII character codes.
	for(int i = 0; i <= 0xFF; i++) {
    	crc32_table[i] = reflect(i, 8) << 24;
       	for (int j = 0; j < 8; j++)
			crc32_table[i] = (crc32_table[i] << 1) ^ (crc32_table[i] & (1 << 31) ? poly : 0);
        crc32_table[i] = reflect(crc32_table[i], 32);
    }
	logDebug("absUtil::CRC init done.");
	//unsigned char test[100] = "123456789";
	//logDebug(iths(GetCRC(test,9))); //test: should output CBF43926
}

/* reflects a ch-bit integer (eg 1010 becomes 0101) */
uint absUtil::reflect(uint ref, char ch) {
	uint value(0);

    //swap bit 0 for bit 7, bit 1 for bit 6, etc.
    for(int i = 1; i < (ch + 1); i++) {
         if(ref & 1) value |= 1 << (ch - i);
         ref >>= 1;
    }
    return value;
}

/** 
 * generates a CRC32 value using the reflected table algorithm
 * for more information on CRC algorithms, see: 
 * A painless guide to CRC error detection algorithms
 * by Ross N. Williams
 */
uint absUtil::GetCRC(unsigned char* data, int length) {
     uint crc(0xffffffff); //CRC register with initial value for CRC32
	
	logDebug(string((char*)data));
     for(int i=0; i< length; i++) {
        crc = (crc >> 8) ^ crc32_table[(crc & 0xFF) ^ data[i]];
	 }

     //exclusive OR the result with the final value for CRC32
     return crc^0xffffffff;
}
