#include "buildplaylist.h"

#include "playlist.h"
#include "lpsettings.h"

BuildPlaylist::BuildPlaylist(Playlist* list) : _done(true), _list(list) { }

BuildPlaylist::~BuildPlaylist() { }

Playlist* BuildPlaylist::getPlaylist() { return _list; }

bool BuildPlaylist::done() { return _done; }

void BuildPlaylist::start() {
	_done = false;
	_list->startBuilding();
	_done = true;
}

void BuildPlaylist::stop() {
	_list->stopBuilding();
}
