/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_COMPPLAYLIST
#define H_COMPPLAYLIST

#include "lpglobal.h"
#include "playlist.h"

#include <vector>
using namespace std;

/** a playlist that is based on a set of directories */
class CompositePlaylist : public Playlist {
public:
	CompositePlaylist();
	/** deletes all playlists */
	~CompositePlaylist();
	CompositePlaylist(string name);

	/** important convention for now: the first added playlists is a directoryplaylist
	 *  TODO: use getType to get rid of this convention
	 */
    void addPlaylist(Playlist*);
	void removePlaylist(string name);
	vector<Playlist*> getPlaylists();

	//redefined
	void stopBuilding();

	virtual bool equals(Playlist*); //redefined
    virtual int getType();
    static const int TYPE;	
private:
	virtual void buildInit(vector<string>*);
	virtual void buildStep(vector<string>*);
	virtual void buildCleanup(vector<string>*);

	vector<Playlist*> _playlists;
};

#endif
