#include "directoryplaylist.h"
#include "absutil.h"

#include <qdir.h>
#include <qstringlist.h>
#include <qregexp.h>

const int DirectoryPlaylist::TYPE = 12;

int DirectoryPlaylist::getType() { return TYPE; }
DirectoryPlaylist::DirectoryPlaylist() : Playlist("noname") {}
DirectoryPlaylist::DirectoryPlaylist(string name) : Playlist(name) {}

bool DirectoryPlaylist::equals(Playlist* list) {
	logDebug("dirplaylist::equals");
	if (list->getType() != TYPE) return false;
	DirectoryPlaylist *dlist = (DirectoryPlaylist*) list;
	if (!compVector(getDirs(), dlist->getDirs())) return false;
//vectors, do they support this already?? I guess?
	if (getIncludeSubDirs() != dlist->getIncludeSubDirs()) return false;
	logDebug("dirplaylist::equals passed.");
	return Playlist::equals(list);
}

bool DirectoryPlaylist::compVector(vector<string> d1,vector<string> d2) {
	if (d1.size() != d2.size()) return false;
	for (uint i=0;i<d1.size();i++)
		if (d1[i] != d2[i]) return false;
	return true;
}

void DirectoryPlaylist::removeDir(string dir) { vector<string> tempD = _dirs;
	vector<bool> tempI = _includeSubDirs;
	_dirs.clear();
	_includeSubDirs.clear();
	for (uint i=0;i<tempD.size();i++) {
		if (tempD[i] != dir) {
			_dirs.push_back(tempD[i]);
			_includeSubDirs.push_back(tempI[i]);
		}
	}
}

/** adds a directory to search in */
void DirectoryPlaylist::addDir(string dir, bool incl) {
    _dirs.push_back(dir);
    _includeSubDirs.push_back(incl);
}

void DirectoryPlaylist::clearDirs() {
    _dirs = vector<string>();
    _includeSubDirs = vector<bool>();
}

void DirectoryPlaylist::setDirs(vector<string> name, vector<bool> name2) {
    _dirs = name; _includeSubDirs = name2;
}

vector<string> DirectoryPlaylist::getDirs() const {
    return _dirs;
}

vector<bool> DirectoryPlaylist::getIncludeSubDirs() const {
    return _includeSubDirs;
}

void DirectoryPlaylist::buildStep(vector<string>* /*temp*/) {
}
void DirectoryPlaylist::buildCleanup(vector<string>* /*temp*/) {
}
void DirectoryPlaylist::buildInit(vector<string>* temp) {
    logDebug(string("DirectoryPlaylist::building list of files..."));
    //directories to look in
    vector<string> dirs = getDirs();
    vector<bool> incsubdirs = getIncludeSubDirs();
    vector<string> * cache = temp;
    cache->clear();

    if (dirs.size() == 0) 
		logWarning("DirectoryPlaylist::cannot build filelist: empty playlist!"); 
	for (uint i=0;i<dirs.size();i++) {
		if (_abort) return;
		logDebug(string("DirectoryPlaylist::building list...  (") + dirs[i] + ")");
		putFilesInDir(cache, dirs[i],incsubdirs[i]);
	}

    logDebug(string("DirectoryPlaylist::building list... done (") + absUtil::its(cache->size()) + " files)");
	_buildMutex->lock();
	_built = true;
	_buildMutex->unlock();
}

/** Recursive function: Traverses directory and puts all files in the supplied vector
  * arguments: 
  * fileList: vector to store files in 
  * dir: directory to search in
  * subdirstoo: specifies if subdirs need to be searched as well
  * uses filemasks and excludemasks!
  * symlinks to dirs are encountered, their contents are added too
  */
void DirectoryPlaylist::putFilesInDir(vector<string>* fileList,string dir,bool subdirstoo) {
	if (_abort) return;
    //logDebug(string("Reading ") + dir);
    vector<string> * cache = fileList;
	QString dirName = QString::fromLocal8Bit(dir.c_str());
    if (_abort) { logWarning("DirectoryPlaylist::aborting."); return; }
	if (dir.empty() || !QDir(dirName).exists() ) return;

    QDir d(dirName);
    d.setFilter( QDir::All);

	const QFileInfoList *list = d.entryInfoList();
    if (list) {
		QFileInfoListIterator it(*list);  // create list iterator
       	QFileInfo *fi;                    
       	while ( !_abort && (fi=it.current()) ) {     // iterate over files
           	if ((fi->fileName() != ".") && (fi->fileName() != "..")) {
				while (fi->isSymLink()) fi->setFile(fi->readLink());
				if (fi->isDir() && subdirstoo) {
					putFilesInDir(cache, string(fi->filePath().local8Bit()),subdirstoo);
				}
				if (fi->isFile()) {
					string filename = string(fi->filePath().local8Bit());
					if (validFilename(filename)) cache->push_back(filename);
				}
           	}
           	++it;                               // goto next list element
       }
    }
}

bool DirectoryPlaylist::isDirectory(string filename) {
    if (filename.empty()) return false;    
	QDir d(QString::fromLocal8Bit(filename.c_str()));
	return d.exists();
}   
