/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef H_DIRPLAYLIST
#define H_DIRPLAYLIST

#include "lpglobal.h"
#include "playlist.h"

#include <vector>
using namespace std;

/** a playlist that is based on a set of directories */
class DirectoryPlaylist : public Playlist {
public:
	DirectoryPlaylist();
	DirectoryPlaylist(string name);

    /** adds a directory to search in */
    void addDir(string dir, bool includesubdirs);
    void removeDir(string dir);
    /** deletes all directories to search in */
    void  clearDirs();

    void setDirs(vector<string>, vector<bool> includesubdirs);
    vector<string> getDirs() const;
    vector<bool> getIncludeSubDirs() const;
	
	virtual bool equals(Playlist*); //redefined
	
	static bool isDirectory(string filename);
    virtual int getType();
    static const int TYPE;
	
private:
	virtual void buildInit(vector<string>*);
	virtual void buildStep(vector<string>*);
	virtual void buildCleanup(vector<string>*);

    void putFilesInDir(vector<string>* , string, bool subdirs);
	bool compVector(vector<string>,vector<string>);

	vector<string> _dirs;
    vector<bool> _includeSubDirs;
};

#endif
