#include "genrewidget.h"
#include "lpglobal.h"
#include "lpsettings.h"
#include "absutil.h"

#include <qpixmap.h>
#include <qframe.h>
#include <qheader.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpicture.h>
#include <qpixmap.h>
#include <qpainter.h>

GenreConstraintWidget::GenreConstraintWidget(QWidget* parent, const char* name) : QFrame(parent, name), _message(""), x1(0),y1(0),x2(0),y2(0) {
	setMinimumHeight(94); setMaximumHeight(94);
	setMinimumWidth(184); setMaximumWidth(184);

	QString imgPrefix = LPSettings::getResourceDir().c_str();
	QString imgEnabled = imgPrefix + "/images/genre.png";
	QString imgDisabled = imgPrefix + "/images/genre-disabled.png";

    pictEnabled = new QPixmap;
    if ( !pictEnabled->load(imgEnabled) ) {              // cannot load picture
        delete pictEnabled;
        pictEnabled = 0;
    }

    pictDisabled = new QPixmap;
    if ( !pictDisabled->load(imgDisabled) ) {              // cannot load picture
        delete pictDisabled ;
        pictDisabled = 0;
    }

	pict = pictEnabled;
}

void GenreConstraintWidget::setEnabled(bool b) {
	if (b) pict = pictEnabled; else pict = pictDisabled;
	QFrame::setEnabled(b);
}

void GenreConstraintWidget::getConstraint(int* nx1, int* ny1, int* nx2, int* ny2) {
	*nx1 = x1; *nx2 = x2;
	*ny1 = y1; *ny2 = y2;
}

void GenreConstraintWidget::setConstraint(int nx1, int ny1, int nx2, int ny2) {
	x1 = nx1; y1 = ny1; x2 = nx2; y2 = ny2;
	update();
}

GenreConstraintWidget::~GenreConstraintWidget() { delete pict; }

void GenreConstraintWidget::drawIt(QPainter* p) {
	QRect r = contentsRect();
	if ((x1 == x2) && (y1 == y2)) pict = pictDisabled; else pict = pictEnabled;

    if ( pict )
        p->drawPixmap(r.left(),r.top(), *pict ); //draw picture
    else
        p->drawText( rect(), AlignCenter, "no image" );

    p->setPen( Qt::black );
	if ((x1 == x2) && (y1 == y2)) {
		if (!_message.isEmpty()) 
    	p->drawText( rect(), AlignCenter, _message );
		return;
	}
	int nx1, ny1, nx2, ny2;
	nx1 = x1 * r.width() /255;
	ny1 = y1 * r.height() /255;
	nx2 = x2 * r.width() /255;
	ny2 = y2 * r.height() /255;
    p->drawRect( r.left()+ nx1,r.top() + ny1, nx2 - nx1, ny2 - ny1); // draw the rectangle
}

void GenreConstraintWidget::paintEvent(QPaintEvent* e) {
   QFrame::paintEvent(e);
   QPainter paint( this );
   drawIt( &paint );
}

void GenreConstraintWidget::setMessage(QString s) { _message = s; }
void GenreConstraintWidget::resizeEvent(QResizeEvent* /*e*/) { }
void GenreConstraintWidget::mouseReleaseEvent(QMouseEvent* /*e*/) { emit constraintChanged(x1,y1,x2,y2); }

void GenreConstraintWidget::mousePressEvent(QMouseEvent* e){
	int nx, ny;
	QRect r = contentsRect();
	nx = (e->x()-r.left())*255/r.width();
	ny = (e->y()-r.top())*255/r.height();
	setConstraint(nx,ny,nx,ny);
}

void GenreConstraintWidget::mouseMoveEvent(QMouseEvent *e){
	int nx2, ny2;
	QRect r = contentsRect();
	logDebug("coords: " + absUtil::its(e->x()) + "/" + absUtil::its(e->y()));
	nx2 = (e->x()-r.left())*255/r.width();
	if (nx2 > 255) nx2 = 255;
	if (nx2 < 0) nx2 = 0;
	ny2 = (e->y()-r.top())*255/r.height();
	if (ny2 > 255) ny2 = 255;
	if (ny2 < 0) ny2 = 0;
	logDebug("hue: " + absUtil::its(nx2) + "/" + absUtil::its(ny2));
	setConstraint(x1,y1,nx2,ny2);
}

GenreWidget::GenreWidget(QWidget* parent, const char* name) : QFrame(parent, name), _message("") {
	//setBackgroundColor( white );
	setMinimumHeight(94);
	setMaximumHeight(94);
	setMinimumWidth(184);
	setMaximumWidth(184);

	QString imgPrefix = LPSettings::getResourceDir().c_str();
	QString imgEnabled = imgPrefix + "/images/genre.png";
	QString imgDisabled = imgPrefix + "/images/genre-disabled.png";

    pictEnabled = new QPixmap;
    if ( !pictEnabled->load(imgEnabled) ) {              // cannot load picture
        delete pictEnabled;
        pictEnabled = 0;
    }

    pictDisabled = new QPixmap;
    if ( !pictDisabled->load(imgDisabled) ) {              // cannot load picture
        delete pictDisabled ;
        pictDisabled = 0;
    }

	pict = pictEnabled;
}

void GenreWidget::setEnabled(bool b) {
	if (b) pict = pictEnabled; else pict = pictDisabled;
	QFrame::setEnabled(b);
}

void GenreWidget::setGenre(int nx, int ny, int nz) {
	x = nx; y = ny; z = nz;
	update();
}

GenreWidget::~GenreWidget() { delete pict; }

void GenreWidget::drawIt(QPainter* p) {
	QRect r = contentsRect();
    if ( pict )
        p->drawPixmap(r.left(),r.top(), *pict );             // draw picture
    else
        p->drawText( rect(), AlignCenter, "no image" );

    p->setPen( Qt::black );
	if ((x < 0) || !isEnabled()) {
		if (!_message.isEmpty()) 
    	p->drawText( rect(), AlignCenter, _message );
		return;
	}
	int nx, ny;
	nx = x * r.width() /255;
	ny = y * r.height() /255;
	//logDebug(string("drawing at: ") + absUtil::its(r.left()+nx) + "/" + absUtil::its(r.top()+ny));
    p->drawRect( r.left()+ nx-2,r.top() + ny-2, 4,4 );         // draw the rectangle
}

void GenreWidget::paintEvent(QPaintEvent* e) {
   QFrame::paintEvent(e);
   QPainter paint( this );
   drawIt( &paint );
}

void GenreWidget::resizeEvent(QResizeEvent* /*e*/) { } 
void GenreWidget::setMessage(QString s) { _message = s; }

void GenreWidget::mouseReleaseEvent(QMouseEvent* e) {
//	if (!editable) return;
	int nx, ny;
	QRect r = contentsRect();
	logDebug("coords: " + absUtil::its(e->x()) + "/" + absUtil::its(e->y()));
	nx = (e->x()-r.left())*255/r.width();
	ny = (e->y()-r.top())*255/r.height();
	logDebug("hue: " + absUtil::its(nx) + "/" + absUtil::its(ny));
	setGenre(nx,ny,z);
	emit genreChanged(x,y,z);
}

