#include "logqt.h"

#include "absutil.h"
#include "lpguihandler.h"
#include "lpsettings.h"

#include <qtextstream.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qprogressbar.h>
#include <qstatusbar.h>
#include <qthread.h>
#include <qfile.h>
#include <qprogressdialog.h>
#include <qwidget.h>

#include <fstream>
#include <iostream>

#ifdef _WS_WIN_
#include "windows.h"
#endif

/* default: 
 * - no debugging output on screen
 * - debug output to file debuglog.txt in the lplayer settings dir
 */
LogQt::LogQt(bool debug) : _debug(0) {
	_application = 0;
	_output = 0;
	_widget = 0;
	_file = 0;
	string filename = LPSettings::getLPHomeDir() + "/debuglog.txt";
	setLogFile(filename);
	setDebug(debug);
}

/* closes debug output file, if present */
LogQt::~LogQt() {
	if (_file) {
		delete _stream;
		delete _file; //also closes
	}
#ifdef _WS_WIN_
	if (_debug) {
		string i;
		cin >> i; //do not let the console disappear...
		FreeConsole();
	}
 #endif
}

void LogQt::setDebug(bool debug) {
	#ifdef _WS_WIN_
		if (_debug && !debug)
			FreeConsole();
		if (!_debug && debug) {
			// allocate a console for this app
			AllocConsole();
			freopen("CONIN$","rb",stdin);   // reopen stdin handle as console window input
			freopen("CONOUT$","wb",stdout);  // reopen stout handle as console window output
			freopen("CONOUT$","wb",stderr); // reopen stderr handle as console window output
		}
	 #endif
	_debug = debug;
}

void LogQt::setLogFile(string filename) {
   _file = new QFile(filename.c_str());
    if (!_file->open(IO_WriteOnly | IO_Truncate)) {
		cout << "could not dump debugging output.. expect a crash\n";
		delete _file;
		_file = 0;
		return;
    }
    _stream = new QTextStream(_file);
}

void LogQt::setWidget(QWidget* output) {
	_widget = output;
}

void LogQt::setOutput(QObject* output) {
	_output = output;
}

void LogQt::setApplication(QApplication* application) {
	_application = application;
}

QApplication* LogQt::getApplication() {
	return _application;
}

 bool LogQt::progressSet(int i) {
	if (_widget && i && _progress) {
		_progress->setProgress(i);
		qApp->processEvents();
	}
	return false;
}

 void LogQt::progressInit(string text, int steps) {
	if (_widget)
	{
		_progress = new QProgressDialog ( text.c_str(), 0, steps,_widget);
		qApp->processEvents();
	}
}

void LogQt::progressEnd() {
	if (_widget && _progress)
		_progress->reset();
	_progress = 0;
}

 void LogQt::debug(int text) { debug(absUtil::its(text)); }

 void LogQt::debug(string text) {
	if (_debug) cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(1,text));
}

 void LogQt::message(string text) {
	if (_debug) cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(LPGUIEvent::LPMESSAGE,text));
	else {
		QMessageBox::information( 0, "LongPlayer", text.c_str());
	}
 }

 void LogQt::info(string text, int displaylength) {
	if (_debug || !_output) cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(2,text, displaylength));
}

void LogQt::busy(string text, bool modal) {
	if (_debug || !_output) cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(LPGUIEvent::BUSY,text, modal));
}

void LogQt::ready(string text) {
	if (_debug || !_output) cout << text << "\n";
	(*_stream) << text.c_str() << " done.\n";
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(LPGUIEvent::READY,text));
}

void LogQt::oops(string text) {
	if (_debug || !_output) cout << text << "\n";
	(*_stream) <<
"         \\|/ ____ \\|/"    "\n"
" OOPS!   \"@'/ .. \\`@\""  "\n"
"         /_| \\__/ |_\\\"" "\n"
"            \\__U_/"       "\n";
	(*_stream) << text.c_str() << "\n";
	_stream->device()->flush();
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(4,
		"Oops! Something happened and it isn't good. LPlayer might not function correctly anymore."));
}

 void LogQt::error(string text) {
	if (_debug || !_output) cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
	_stream->device()->flush();
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(4,text));
}

 void LogQt::warning(string text) {
	if (_debug || !_output) cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
	(*_stream) << "                                                              [!]" << "\n";
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(3,text));
}

