#include "logwa.h"

#include "absutil.h"
#include "lpguihandler.h"
#include "lpsettings.h"

#include <qtextstream.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qprogressbar.h>
#include <qstatusbar.h>
#include <qthread.h>
#include <qfile.h>
#include <qprogressdialog.h>
#include <qwidget.h>

#ifdef _WS_WIN_

//winamp 3 stuff
#ifdef _WS_WINAMP3_
#include "lpwindowmainwa3.h"
#endif	// winamp 3

//#include "../../studio/api.h"
//#include "resource.h"
//#include "../../bfc/msgbox.h"
#include "windows.h"
#endif

LogWA::LogWA(bool debug) : _debug(debug)
{
	_application = 0;
	_output = 0;
	_widget = 0;
	_file = 0;
	_listener = 0;
	string filename = LPSettings::getLPHomeDir() + "/debuglog.txt";
	setLogFile(filename);
	setDebug(debug);
}

LogWA::~LogWA()
{
	if (_file)
	{
		delete _stream;
		delete _file; //also closes
	}
}
void LogWA::setDebug(bool debug)
{
	_debug = debug;
}

void LogWA::setListener(LPWindowMainWA3* listener)
{
	_listener = listener;
}

void LogWA::setLogFile(string filename)
{
   _file = new QFile(filename.c_str());
    if (!_file->open(IO_WriteOnly | IO_Truncate))
    {
			cout << "could not dump debugging output.. expect a crash\n";
			delete _file;
			_file = 0;
            return;
    }
    _stream = new QTextStream(_file);
}
void LogWA::setWidget(QWidget* output)
{
	_widget = output;
}

void LogWA::setOutput(QObject* output)
{
	_output = output;
}
void LogWA::setApplication(QApplication* application)
{
	_application = application;
}
QApplication* LogWA::getApplication()
{
	return _application;
}
/** stores UI elements and variables for global debugging messages
 */
 bool LogWA::progressSet(int i)
{
	if (_widget && i && _progress)
	{
		_progress->setProgress(i);
		qApp->processEvents();
	}
	return false;
}
 void LogWA::progressInit(string text, int steps)
{
	if (_widget)
	{
		_progress = new QProgressDialog ( text.c_str(), 0, steps,_widget);
		qApp->processEvents();
	}
//QThread::postEvent ( _output, new LPGUIEvent(LPGUIEvent::LPBEGINPROGRESS,text,steps));
}
 void LogWA::progressEnd()
{
 if (_widget && _progress)
	_progress->reset();
 _progress = 0;
//	 QThread::postEvent ( _output, new LPGUIEvent(LPGUIEvent::LPENDPROGRESS,""));
}

/** debugging messages */
 void LogWA::debug(int text)
{
    debug(absUtil::its(text));
}
 void LogWA::debug(string text)
{
	if (_debug)
	cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
 if (_output) QThread::postEvent ( _output, new LPGUIEvent(1,text));

 if (_listener) _listener->corecb_outputString(text.c_str());;
}
/** displays a message to the user */
 void LogWA::message(string text)
{
	if (_debug)
	cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
		 if (_output) QThread::postEvent ( _output, new LPGUIEvent(LPGUIEvent::LPMESSAGE,text));
		 else
		 {
			 QMessageBox::information( 0, "LongPlayer",
                                      text.c_str());
		 }
//		    api->messageBox(text.c_str(), "FreeForm Component Example", MSGBOX_OK, NULL, NULL);

 //TODOCRIT REPLACE BY SOMETHING THREADSAFE if (_listener) _listener->corecb_outputString(text.c_str());;
 }
/** normal debugging message (purely informative, high entertainment value)
 *  if displaylength == 0 => until next message
*/
 void LogWA::info(string text, int displaylength)
{
	if (_debug || !_output)
	cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
	  if (_output) QThread::postEvent ( _output, new LPGUIEvent(2,text, displaylength));

 if (_listener) _listener->corecb_outputString(text.c_str());;
}
void LogWA::oops(string text)
{
	if (_debug || !_output)
	cout << text << "\n";
	(*_stream) <<
"         \\|/ ____ \\|/"    "\n"
" OOPS!   \"@'/ .. \\`@\""  "\n"
"         /_| \\__/ |_\\\"" "\n"
"            \\__U_/"       "\n";
	(*_stream) << text.c_str() << "\n";
	if (_output) QThread::postEvent ( _output, new LPGUIEvent(4,
		"Oops! Something happened and it isn't good. LPlayer might not function correctly anymore."));
	if (_listener) _listener->corecb_outputString(text.c_str());;
}

/** severe error message  */
 void LogWA::error(string text)
{
	if (_debug || !_output)
	cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
	  if (_output) QThread::postEvent ( _output, new LPGUIEvent(4,text));
 if (_listener) _listener->corecb_outputString(text.c_str());;
}
/** recoverable error message  */
 void LogWA::warning(string text)
{
	if (_debug || !_output)
			cout << text << "\n";
	(*_stream) << text.c_str() << "\n";
  if (_output) QThread::postEvent ( _output, new LPGUIEvent(3,text));
 if (_listener) _listener->corecb_outputString(text.c_str());;

}

