/** LongPlayer - cross-platform multimedia queuer
 *  Copyright (C) 2001-2004 Andrew Wils
 *
 *  This program is free software; See the
 *  GNU General Public License for more details.
 */
#ifndef LPARGPARSER_H
#define LPARGPARSER_H

#include "lpsettings.h"
#include <qmap.h>

/** LPArgParser: parses startup command line arguments passed to lplayer
 *  and transforms them into settings
 */
class LPArgParser {
	public:
		/** construct a new argumentparser, using existing settings */
		LPArgParser(int argc,char* argv[], LPSettings* settings);
		/** true when a valid commandline was given */
		bool valid();
		//TODO return tasks to be executed by GUI
	private:
		void displayHelp();
		LPSettings* _settings;
		bool _valid;
		// valid command line options, nr of arguments for each option and setting that should be changed accordingly
		QMap<string, int>* tokens;
		vector<int>* nrArgs;
		vector<string>* settingnames;

};

#endif
