#include <db_cxx.h>
#include <cstring>
#include <iostream>//FIXME: temporary
#include <sstream>
#include <stdlib.h>

#include "lpberkeleydbreader.h"
#include "lpdatabaseiterator.h"
#include "lpsettings.h"

#define MAX_KEY_LENGTH 1024
#define MAX_DATA_LENGTH 1024

#define DB_VERSION 1

LPBerkeleyDBReader::LPBerkeleyDBReader(string filename) 
{
    int ret;

    /* Initialize database environment */
    dbenv = new DbEnv(DB_CXX_NO_EXCEPTIONS);
    if ((ret=dbenv->open( string(LPSettings::getLPHomeDir()).c_str(),
	        DB_CREATE | DB_INIT_LOG | DB_INIT_MPOOL,0))) {
        dbenv->err(ret,"");
        exit(0);
    }

    /* Initialize database */
    db = new Db(dbenv, DB_CXX_NO_EXCEPTIONS); 
    db->set_errpfx("DB4 Error");
    if ((ret=db->open(NULL, string(filename+".db").c_str(), 
            NULL, DB_HASH, DB_CREATE, 0664))) {
        db->err(ret,"");
        exit(0);
    }

    /* Do version checking */
    int version;
    if (!(version=getVersion())) {
        /* Set version number */
        setVersion(DB_VERSION);
    }
}

LPBerkeleyDBReader::~LPBerkeleyDBReader()
{
    db->close(0);
    delete db;
}

void LPBerkeleyDBReader::flush()
{
    db->sync(0);
}

void LPBerkeleyDBReader::compact()
{
    db->sync(0);
}

void LPBerkeleyDBReader::store(Song song)
{
    int ret;
    int h, s, v;
    char songkey[MAX_KEY_LENGTH], songdata[MAX_DATA_LENGTH];
    size_t len;
    char* p;

    /* Create the key */
    memcpy(songkey,song.getKey().c_str(),song.getKey().length()+1);
    Dbt key(songkey,song.getKey().length()+1);

    /* Create the data */
    p = &songdata[0];
    len = song.getName().length() + 1;
    memcpy(p,song.getName().c_str(),len); p += len;
    len = song.getFilename().length() + 1; 
    memcpy(p,song.getFilename().c_str(),len); p += len;
    len = song.getDate(); memcpy(p,&len,sizeof(len)); p += sizeof(len);
    len = song.getOldDate(); memcpy(p,&len,sizeof(len)); p += sizeof(len);
    len = song.getTimes(); memcpy(p,&len,sizeof(len)); p += sizeof(len);
    len = song.getLike(); memcpy(p,&len,sizeof(len)); p += sizeof(len);
    len = song.length(); memcpy(p,&len,sizeof(len)); p += sizeof(len);
    
    song.getColor(&h,&s,&v);
    memcpy(p,&h,sizeof(h)); p += sizeof(h);
    memcpy(p,&s,sizeof(s)); p += sizeof(s);
    memcpy(p,&v,sizeof(v)); p += sizeof(v);

    Dbt data(songdata,(long) p - (long) &songdata[0]);

    /* Store data */
    if((ret=db->put(NULL,&key,&data,0))) {
        db->err(ret,"");
        exit(0);
    }
}

void LPBerkeleyDBReader::remove(Song song)
{
    int ret;
    char songkey[MAX_KEY_LENGTH];
    
    memcpy(songkey,song.getKey().c_str(),song.getKey().length()+1);
    Dbt dbkey(songkey,song.getKey().length()+1);
    if ((ret=db->del(NULL,&dbkey,0))) {
        db->err(ret,"");
        exit(0);
    }
}

Song LPBerkeleyDBReader::retrieve(string key)
{
    int ret;
    char songkey[MAX_KEY_LENGTH];
    
    memcpy(songkey,key.c_str(),key.length()+1);
    Dbt dbkey(songkey,key.length()+1);
    Dbt dbdata;
    if ((ret=db->get(NULL,&dbkey,&dbdata,0))) {
        if (ret == DB_NOTFOUND) {
            Song s;
            return s;
        }
        db->err(ret,"");
        exit(0);
    }
    Song s(key);
    readData((char*) dbdata.get_data(),&s);
    return s;
}

bool LPBerkeleyDBReader::inDatabase(string key)
{
    char songkey[MAX_KEY_LENGTH];
    memcpy(songkey,key.c_str(),key.length()+1);
    Dbt dbkey(songkey,key.length()+1);
    Dbt dbdata;
    return !(db->get(NULL,&dbkey,&dbdata,0));
}

int LPBerkeleyDBReader::getSize()
{
    int size, ret;
    DB_HASH_STAT* stats;
    
    if ((ret=db->stat(&stats,0))) {
        db->err(ret,"");
        exit(0);
    }
    size = stats->hash_nkeys;
    delete stats;
    return size;
}

void LPBerkeleyDBReader::readData(char* data, Song *sng)
{
    int n;
    int h, s, v;
    string str;
    char* p;

    p = data;
    str = string(p); sng->setName(str); p += str.length()+1; 
    str = string(p); sng->setFilename(str); p += str.length()+1;
    memcpy(&n,p,sizeof(n)); sng->setDate(n); p += sizeof(n); 
    memcpy(&n,p,sizeof(n)); sng->setOldDate(n); p += sizeof(n); 
    memcpy(&n,p,sizeof(n)); sng->setTimes(n); p += sizeof(n); 
    memcpy(&n,p,sizeof(n)); sng->setLike(n); p += sizeof(n); 
    memcpy(&n,p,sizeof(n)); sng->setLength(n); p += sizeof(n); 
    
    memcpy(&h,p,sizeof(h)); p += sizeof(h); 
    memcpy(&s,p,sizeof(s)); p += sizeof(s); 
    memcpy(&v,p,sizeof(v)); p += sizeof(v); 
    sng->setColor(h,s,v);
}


int LPBerkeleyDBReader::getVersion()
{
    int ret;
    
    Dbt dbkey((char*) "__DBVERSION__",13);
    Dbt dbdata;
    if ((ret=db->get(NULL,&dbkey,&dbdata,0))) {
        if (ret == DB_NOTFOUND) 
            return 0;
        
        db->err(ret,"");
        exit(0);
    }

    return atoi((char*) dbdata.get_data());
}
    
void LPBerkeleyDBReader::setVersion(int v)
{
    int ret;
    ostringstream versionstr;
    versionstr << v;

    Dbt dbkey((char*) "__DBVERSION__",13);
    Dbt dbdata((char*) versionstr.str().c_str(), versionstr.str().length() + 1);
    if((ret=db->put(NULL,&dbkey,&dbdata,0))) {
        db->err(ret,"");
        exit(0);
    }
}

/************************ Iterator stuff **********************************/

class LPBerkeleyDBReader::LPBerkeleyDBIterator : public LPDatabaseIterator
{
  public:
    LPBerkeleyDBIterator(Dbc* cursor_) : cursor(cursor_) {}
    ~LPBerkeleyDBIterator();

    void reset();
    Song next();
    bool atEnd();
                                   
  private:
    Dbc* cursor;
};  

LPBerkeleyDBReader::LPBerkeleyDBIterator::~LPBerkeleyDBIterator()
{
    cursor->close();
}

void LPBerkeleyDBReader::LPBerkeleyDBIterator::reset() {
    Dbt dbkey, dbdata;
    cursor->get(&dbkey,&dbdata,DB_FIRST);
}
	
Song LPBerkeleyDBReader::LPBerkeleyDBIterator::next() {
    Dbt dbkey, dbdata;
    cursor->get(&dbkey,&dbdata,DB_CURRENT);
    Song s(string((char*) dbkey.get_data()));
    LPBerkeleyDBReader::readData((char*) dbdata.get_data(),&s);
    cursor->get(&dbkey,&dbdata,DB_NEXT);
    return s;
}

bool LPBerkeleyDBReader::LPBerkeleyDBIterator::atEnd() {
    return false;
}

LPDatabaseIterator* LPBerkeleyDBReader::iterator()
{
    Dbc* curs;
    db->cursor(NULL,&curs,0);
    return new LPBerkeleyDBReader::LPBerkeleyDBIterator(curs);
}

